/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.path;

import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.path.PathBuilder;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.raptor.rangeraptor.path.BoardAndAlightTimeSearch;
import org.opentripplanner.raptor.rangeraptor.path.DestinationArrival;
import org.opentripplanner.raptor.rangeraptor.path.PathMapper;
import org.opentripplanner.raptor.rangeraptor.transit.TripTimesSearch;
import org.opentripplanner.raptor.spi.BoardAndAlightTime;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.raptor.spi.RaptorSlackProvider;

public final class ForwardPathMapper<T extends RaptorTripSchedule>
implements PathMapper<T> {
    private final RaptorSlackProvider slackProvider;
    private final RaptorCostCalculator<T> costCalculator;
    private final RaptorStopNameResolver stopNameResolver;
    private final BoardAndAlightTimeSearch tripSearch;
    private final RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch;
    private int iterationDepartureTime = -1;

    public ForwardPathMapper(RaptorSlackProvider slackProvider, RaptorCostCalculator<T> costCalculator, RaptorStopNameResolver stopNameResolver, RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch, WorkerLifeCycle lifeCycle, boolean useApproximateTripTimesSearch) {
        this.slackProvider = slackProvider;
        this.costCalculator = costCalculator;
        this.stopNameResolver = stopNameResolver;
        this.tripSearch = ForwardPathMapper.forwardSearch(useApproximateTripTimesSearch);
        this.transferConstraintsSearch = transferConstraintsSearch;
        lifeCycle.onSetupIteration(this::setRangeRaptorIterationDepartureTime);
    }

    @Override
    public RaptorPath<T> mapToPath(DestinationArrival<T> destinationArrival) {
        PathBuilder<T> pathBuilder = PathBuilder.headPathBuilder(this.slackProvider, this.iterationDepartureTime, this.costCalculator, this.stopNameResolver, this.transferConstraintsSearch);
        pathBuilder.egress(destinationArrival.egressPath().egress());
        block6: for (ArrivalView<T> arrival = destinationArrival.previous(); arrival != null; arrival = arrival.previous()) {
            switch (arrival.arrivedBy()) {
                case TRANSIT: {
                    BoardAndAlightTime times = this.tripSearch.find(arrival);
                    pathBuilder.transit(arrival.transitPath().trip(), times);
                    continue block6;
                }
                case TRANSFER: {
                    pathBuilder.transfer(arrival.transfer(), arrival.stop());
                    continue block6;
                }
                case ACCESS: {
                    pathBuilder.access(arrival.accessPath().access());
                    continue block6;
                }
                case EGRESS: {
                    throw new RuntimeException("Unknown arrival type: " + arrival.getClass().getSimpleName());
                }
            }
        }
        return pathBuilder.build();
    }

    private static BoardAndAlightTimeSearch forwardSearch(boolean useApproximateTimeSearch) {
        return useApproximateTimeSearch ? TripTimesSearch::findTripForwardSearchApproximateTime : TripTimesSearch::findTripForwardSearch;
    }

    private void setRangeRaptorIterationDepartureTime(int iterationDepartureTime) {
        this.iterationDepartureTime = iterationDepartureTime;
    }
}

