/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.path;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.opentripplanner.framework.lang.OtpNumberFormat;
import org.opentripplanner.framework.logging.ThrottleLogger;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.path.Path;
import org.opentripplanner.raptor.rangeraptor.debug.DebugHandlerFactory;
import org.opentripplanner.raptor.rangeraptor.internalapi.DebugHandler;
import org.opentripplanner.raptor.rangeraptor.internalapi.SlackProvider;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.raptor.rangeraptor.path.DestinationArrival;
import org.opentripplanner.raptor.rangeraptor.path.PathMapper;
import org.opentripplanner.raptor.rangeraptor.transit.RaptorTransitCalculator;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.util.paretoset.ParetoComparator;
import org.opentripplanner.raptor.util.paretoset.ParetoSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationArrivalPaths<T extends RaptorTripSchedule> {
    private static final Logger LOG = LoggerFactory.getLogger(DestinationArrivalPaths.class);
    private static final Logger LOG_MISS_MATCH = ThrottleLogger.throttle(LOG);
    private final ParetoSet<RaptorPath<T>> paths;
    private final RaptorTransitCalculator<T> transitCalculator;
    @Nullable
    private final RaptorCostCalculator<T> costCalculator;
    private final SlackProvider slackProvider;
    private final PathMapper<T> pathMapper;
    private final DebugHandler<RaptorPath<?>> debugPathHandler;
    private final RaptorStopNameResolver stopNameResolver;
    private boolean reachedCurrentRound = false;
    private int iterationDepartureTime = -1;

    public DestinationArrivalPaths(ParetoComparator<RaptorPath<T>> paretoComparator, RaptorTransitCalculator<T> transitCalculator, @Nullable RaptorCostCalculator<T> costCalculator, SlackProvider slackProvider, PathMapper<T> pathMapper, DebugHandlerFactory<T> debugHandlerFactory, RaptorStopNameResolver stopNameResolver, WorkerLifeCycle lifeCycle) {
        this.paths = new ParetoSet(paretoComparator, debugHandlerFactory.paretoSetDebugPathListener());
        this.transitCalculator = transitCalculator;
        this.costCalculator = costCalculator;
        this.slackProvider = slackProvider;
        this.pathMapper = pathMapper;
        this.debugPathHandler = debugHandlerFactory.debugPathArrival();
        this.stopNameResolver = stopNameResolver;
        lifeCycle.onPrepareForNextRound(round -> this.clearReachedCurrentRoundFlag());
        lifeCycle.onSetupIteration(this::setRangeRaptorIterationDepartureTime);
    }

    public void add(ArrivalView<T> stopArrival, RaptorAccessEgress egressPath) {
        DestinationArrival<T> destArrival = this.createDestinationArrivalView(stopArrival, egressPath);
        if (destArrival == null) {
            return;
        }
        if (this.transitCalculator.exceedsTimeLimit(destArrival.arrivalTime())) {
            this.debugRejectByTimeLimitOptimization(destArrival);
        } else {
            RaptorPath<T> path = this.pathMapper.mapToPath(destArrival);
            this.assertGeneralizedCostIsCalculatedCorrectByMapper(destArrival, path);
            boolean added = this.paths.add(path);
            if (added) {
                this.reachedCurrentRound = true;
            }
        }
    }

    public boolean isReachedCurrentRound() {
        return this.reachedCurrentRound;
    }

    public void setRangeRaptorIterationDepartureTime(int iterationDepartureTime) {
        this.iterationDepartureTime = iterationDepartureTime;
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public boolean qualify(int departureTime, int arrivalTime, int numberOfTransfers, int cost) {
        return this.paths.qualify(Path.dummyPath(this.iterationDepartureTime, departureTime, arrivalTime, numberOfTransfers, cost));
    }

    public Collection<RaptorPath<T>> listPaths() {
        return this.paths;
    }

    public void debugReject(ArrivalView<T> stopArrival, RaptorAccessEgress egress, String reason) {
        DestinationArrival<T> destinationArrival;
        if (this.isDebugOn() && (destinationArrival = this.createDestinationArrivalView(stopArrival, egress)) != null) {
            this.debugReject(destinationArrival, reason);
        }
    }

    public void debugReject(DestinationArrival<T> arrival, String reason) {
        if (this.isDebugOn()) {
            RaptorPath<T> path = this.pathMapper.mapToPath(arrival);
            this.debugPathHandler.reject(path, null, reason);
        }
    }

    public String toString() {
        return this.paths.toString(p -> p.toString(this.stopNameResolver));
    }

    public final boolean isDebugOn() {
        return this.debugPathHandler != null;
    }

    private void clearReachedCurrentRoundFlag() {
        this.reachedCurrentRound = false;
    }

    private void debugRejectByTimeLimitOptimization(DestinationArrival<T> destArrival) {
        if (this.isDebugOn()) {
            this.debugReject(destArrival, this.transitCalculator.exceedsTimeLimitReason());
        }
    }

    @Nullable
    private DestinationArrival<T> createDestinationArrivalView(ArrivalView<T> stopArrival, RaptorAccessEgress egressPath) {
        int departureTime = this.transitCalculator.calculateEgressDepartureTime(stopArrival.arrivalTime(), egressPath, this.slackProvider.transferSlack());
        if (departureTime == -1999000000) {
            return null;
        }
        int arrivalTime = this.transitCalculator.plusDuration(departureTime, egressPath.durationInSeconds());
        int waitTimeInSeconds = Math.abs(departureTime - stopArrival.arrivalTime());
        int additionalCost = 0;
        if (this.costCalculator != null) {
            additionalCost += this.costCalculator.waitCost(waitTimeInSeconds);
            additionalCost += this.costCalculator.costEgress(egressPath);
        }
        return new DestinationArrival<T>(egressPath, stopArrival, arrivalTime, additionalCost);
    }

    private void assertGeneralizedCostIsCalculatedCorrectByMapper(DestinationArrival<T> destArrival, RaptorPath<T> path) {
        if (path.c1() != destArrival.c1()) {
            LOG_MISS_MATCH.warn("Cost mismatch - Mapper: {}, stop-arrivals: {}, path: {}", new Object[]{OtpNumberFormat.formatCostCenti(path.c1()), this.raptorCostsAsString(destArrival), path.toStringDetailed(this.stopNameResolver)});
        }
    }

    private String raptorCostsAsString(DestinationArrival<T> destArrival) {
        ArrayList<String> arrivalCosts = new ArrayList<String>();
        for (ArrivalView<T> it = destArrival; it != null; it = it.previous()) {
            arrivalCosts.add(OtpNumberFormat.formatCostCenti(it.c1()));
        }
        return String.join((CharSequence)" ", arrivalCosts).replaceAll("\\.00", "");
    }
}

