/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.path;

import org.opentripplanner.raptor.api.model.PathLegType;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.api.view.EgressPathView;

public class DestinationArrival<T extends RaptorTripSchedule>
implements ArrivalView<T> {
    private final ArrivalView<T> previous;
    private final RaptorAccessEgress egress;
    private final int arrivalTime;
    private final int numberOfTransfers;
    private final int c1;

    public DestinationArrival(RaptorAccessEgress egress, ArrivalView<T> previous, int arrivalTime, int additionalCost) {
        this.previous = previous;
        this.egress = egress;
        this.arrivalTime = arrivalTime;
        this.numberOfTransfers = previous.round() - 1;
        this.c1 = previous.c1() + additionalCost;
    }

    @Override
    public int stop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int round() {
        return 1 + this.numberOfTransfers + this.egress.numberOfRides();
    }

    @Override
    public int arrivalTime() {
        return this.arrivalTime;
    }

    @Override
    public int c1() {
        return this.c1;
    }

    @Override
    public int c2() {
        return this.previous.c2();
    }

    @Override
    public ArrivalView<T> previous() {
        return this.previous;
    }

    @Override
    public PathLegType arrivedBy() {
        return PathLegType.EGRESS;
    }

    @Override
    public boolean arrivedAtDestination() {
        return true;
    }

    @Override
    public EgressPathView egressPath() {
        return () -> this.egress;
    }

    @Override
    public boolean arrivedOnBoard() {
        return false;
    }

    public String toString() {
        return this.asString();
    }
}

