/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.multicriteria.configure;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.opentripplanner.raptor.api.model.DominanceFunction;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.request.MultiCriteriaRequest;
import org.opentripplanner.raptor.api.request.RaptorTransitPriorityGroupCalculator;
import org.opentripplanner.raptor.rangeraptor.context.SearchContext;
import org.opentripplanner.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorker;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerState;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoutingStrategy;
import org.opentripplanner.raptor.rangeraptor.multicriteria.McRangeRaptorWorkerState;
import org.opentripplanner.raptor.rangeraptor.multicriteria.McStopArrivals;
import org.opentripplanner.raptor.rangeraptor.multicriteria.MultiCriteriaRoutingStrategy;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.ArrivalParetoSetComparatorFactory;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.McStopArrival;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.McStopArrivalFactory;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.c1.StopArrivalFactoryC1;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.c2.StopArrivalFactoryC2;
import org.opentripplanner.raptor.rangeraptor.multicriteria.heuristic.HeuristicsProvider;
import org.opentripplanner.raptor.rangeraptor.multicriteria.ride.PatternRide;
import org.opentripplanner.raptor.rangeraptor.multicriteria.ride.PatternRideFactory;
import org.opentripplanner.raptor.rangeraptor.multicriteria.ride.c1.PatternRideC1;
import org.opentripplanner.raptor.rangeraptor.multicriteria.ride.c2.PatternRideC2;
import org.opentripplanner.raptor.rangeraptor.multicriteria.ride.c2.TransitPriorityGroupRideFactory;
import org.opentripplanner.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.raptor.rangeraptor.path.configure.PathConfig;
import org.opentripplanner.raptor.util.paretoset.ParetoComparator;
import org.opentripplanner.raptor.util.paretoset.ParetoSet;

public class McRangeRaptorConfig<T extends RaptorTripSchedule> {
    private final SearchContext<T> context;
    private final PathConfig<T> pathConfig;
    private DestinationArrivalPaths<T> paths;

    public McRangeRaptorConfig(SearchContext<T> context) {
        this.context = context;
        this.pathConfig = new PathConfig<T>(context);
    }

    public RaptorWorker<T> createWorker(Heuristics heuristics, BiFunction<RaptorWorkerState<T>, RoutingStrategy<T>, RaptorWorker<T>> createWorker) {
        McRangeRaptorWorkerState<T> state = this.createState(heuristics);
        return createWorker.apply(state, this.createTransitWorkerStrategy(state));
    }

    private RoutingStrategy<T> createTransitWorkerStrategy(McRangeRaptorWorkerState<T> state) {
        return this.includeC2() ? this.createTransitWorkerStrategy(state, this.createPatternRideC2Factory(), PatternRideC2.paretoComparatorRelativeCost(this.dominanceFunctionC2())) : this.createTransitWorkerStrategy(state, PatternRideC1.factory(), PatternRideC1.paretoComparatorRelativeCost());
    }

    private <R extends PatternRide<T>> RoutingStrategy<T> createTransitWorkerStrategy(McRangeRaptorWorkerState<T> state, PatternRideFactory<T, R> factory, ParetoComparator<R> patternRideComparator) {
        return new MultiCriteriaRoutingStrategy<T, R>(state, this.context.createTimeBasedBoardingSupport(), factory, this.context.costCalculator(), this.context.slackProvider(), this.createPatternRideParetoSet(patternRideComparator));
    }

    private McRangeRaptorWorkerState<T> createState(Heuristics heuristics) {
        return new McRangeRaptorWorkerState<T>(this.createStopArrivals(), this.createDestinationArrivalPaths(), this.createHeuristicsProvider(heuristics), this.createStopArrivalFactory(), this.context.costCalculator(), this.context.calculator(), this.context.lifeCycle());
    }

    private McStopArrivalFactory<T> createStopArrivalFactory() {
        return this.includeC2() ? new StopArrivalFactoryC2() : new StopArrivalFactoryC1();
    }

    private McStopArrivals<T> createStopArrivals() {
        return new McStopArrivals<T>(this.context.nStops(), this.context.egressPaths(), this.context.accessPaths(), this.createDestinationArrivalPaths(), this.createFactoryParetoComparator(), this.context.debugFactory());
    }

    private HeuristicsProvider<T> createHeuristicsProvider(Heuristics heuristics) {
        if (heuristics == null) {
            return new HeuristicsProvider();
        }
        return new HeuristicsProvider<T>(heuristics, this.context.roundProvider(), this.createDestinationArrivalPaths(), this.context.debugFactory());
    }

    private <R extends PatternRide<T>> ParetoSet<R> createPatternRideParetoSet(ParetoComparator<R> comparator) {
        return new ParetoSet(comparator, this.context.debugFactory().paretoSetPatternRideListener());
    }

    private DestinationArrivalPaths<T> createDestinationArrivalPaths() {
        if (this.paths == null) {
            this.paths = this.pathConfig.createDestArrivalPathsWithGeneralizedCost();
        }
        return this.paths;
    }

    private ArrivalParetoSetComparatorFactory<McStopArrival<T>> createFactoryParetoComparator() {
        return ArrivalParetoSetComparatorFactory.factory(this.mcRequest().relaxC1(), this.dominanceFunctionC2());
    }

    private MultiCriteriaRequest<T> mcRequest() {
        return this.context.multiCriteria();
    }

    private boolean includeC2() {
        return this.mcRequest().transitPriorityCalculator().isPresent();
    }

    private PatternRideFactory<T, PatternRideC2<T>> createPatternRideC2Factory() {
        return new TransitPriorityGroupRideFactory(this.getTransitPriorityGroupCalculator());
    }

    @Nullable
    private DominanceFunction dominanceFunctionC2() {
        return this.mcRequest().transitPriorityCalculator().map(RaptorTransitPriorityGroupCalculator::dominanceFunction).orElse(null);
    }

    @Nullable
    private RaptorTransitPriorityGroupCalculator getTransitPriorityGroupCalculator() {
        return this.mcRequest().transitPriorityCalculator().orElse(null);
    }
}

