/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals;

import javax.annotation.Nullable;
import org.opentripplanner.raptor.api.model.DominanceFunction;
import org.opentripplanner.raptor.api.model.RelaxFunction;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.McStopArrival;
import org.opentripplanner.raptor.util.paretoset.ParetoComparator;

public interface ArrivalParetoSetComparatorFactory<T extends McStopArrival<?>> {
    public ParetoComparator<T> compareArrivalTimeRoundAndCost();

    public ParetoComparator<T> compareArrivalTimeRoundCostAndOnBoardArrival();

    public static <T extends McStopArrival<?>> ArrivalParetoSetComparatorFactory<T> factory(RelaxFunction relaxC1, @Nullable DominanceFunction c2DominanceFunction) {
        if (relaxC1.isNormal()) {
            return ArrivalParetoSetComparatorFactory.createFactoryC1();
        }
        return c2DominanceFunction == null ? ArrivalParetoSetComparatorFactory.createFactoryRelaxC1(relaxC1) : ArrivalParetoSetComparatorFactory.createFactoryRelaxC2(relaxC1, c2DominanceFunction);
    }

    private static <T extends McStopArrival<?>> ArrivalParetoSetComparatorFactory<T> createFactoryC1() {
        return new ArrivalParetoSetComparatorFactory<T>(){

            @Override
            public ParetoComparator<T> compareArrivalTimeRoundAndCost() {
                return McStopArrival::compareBase;
            }

            @Override
            public ParetoComparator<T> compareArrivalTimeRoundCostAndOnBoardArrival() {
                return (l, r) -> McStopArrival.compareBase(l, r) || McStopArrival.compareArrivedOnBoard(l, r);
            }
        };
    }

    private static <T extends McStopArrival<?>> ArrivalParetoSetComparatorFactory<T> createFactoryRelaxC1(final RelaxFunction rc1) {
        return new ArrivalParetoSetComparatorFactory<T>(){

            @Override
            public ParetoComparator<T> compareArrivalTimeRoundAndCost() {
                return (l, r) -> McStopArrival.relaxedCompareBase(rc1, l, r);
            }

            @Override
            public ParetoComparator<T> compareArrivalTimeRoundCostAndOnBoardArrival() {
                return (l, r) -> McStopArrival.relaxedCompareBase(rc1, l, r) || McStopArrival.compareArrivedOnBoard(l, r);
            }
        };
    }

    private static <T extends McStopArrival<?>> ArrivalParetoSetComparatorFactory<T> createFactoryRelaxC2(final RelaxFunction relaxC1, final DominanceFunction c2DominanceFunction) {
        return new ArrivalParetoSetComparatorFactory<T>(){

            @Override
            public ParetoComparator<T> compareArrivalTimeRoundAndCost() {
                return (l, r) -> c2DominanceFunction.leftDominateRight(l.c2(), r.c2()) ? McStopArrival.relaxedCompareBase(relaxC1, l, r) : McStopArrival.compareBase(l, r);
            }

            @Override
            public ParetoComparator<T> compareArrivalTimeRoundCostAndOnBoardArrival() {
                return (l, r) -> (!c2DominanceFunction.leftDominateRight(l.c2(), r.c2()) ? McStopArrival.compareBase(l, r) : McStopArrival.relaxedCompareBase(relaxC1, l, r)) || McStopArrival.compareArrivedOnBoard(l, r);
            }
        };
    }
}

