/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.multicriteria;

import java.util.Collection;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerResult;
import org.opentripplanner.raptor.rangeraptor.internalapi.SingleCriteriaStopArrivals;
import org.opentripplanner.raptor.rangeraptor.multicriteria.McStopArrivals;
import org.opentripplanner.raptor.rangeraptor.path.DestinationArrivalPaths;

public class McRaptorWorkerResult<T extends RaptorTripSchedule>
implements RaptorWorkerResult<T> {
    private final McStopArrivals<T> stopArrivals;
    private final DestinationArrivalPaths<T> paths;

    public McRaptorWorkerResult(McStopArrivals<T> arrivals, DestinationArrivalPaths<T> paths) {
        this.stopArrivals = arrivals;
        this.paths = paths;
    }

    @Override
    public Collection<RaptorPath<T>> extractPaths() {
        return this.paths.listPaths();
    }

    @Override
    public SingleCriteriaStopArrivals extractBestOverallArrivals() {
        return new SingleCriteriaStopArrivals(){

            @Override
            public boolean isReached(int stop) {
                return McRaptorWorkerResult.this.stopArrivals.reached(stop);
            }

            @Override
            public int value(int stop) {
                return McRaptorWorkerResult.this.stopArrivals.bestArrivalTime(stop);
            }
        };
    }

    @Override
    public SingleCriteriaStopArrivals extractBestTransitArrivals() {
        return new SingleCriteriaStopArrivals(){

            @Override
            public boolean isReached(int stop) {
                return McRaptorWorkerResult.this.stopArrivals.reachedByTransit(stop);
            }

            @Override
            public int value(int stop) {
                return McRaptorWorkerResult.this.stopArrivals.bestTransitArrivalTime(stop);
            }
        };
    }

    @Override
    public SingleCriteriaStopArrivals extractBestNumberOfTransfers() {
        return new SingleCriteriaStopArrivals(){

            @Override
            public boolean isReached(int stop) {
                return McRaptorWorkerResult.this.stopArrivals.reached(stop);
            }

            @Override
            public int value(int stop) {
                return McRaptorWorkerResult.this.stopArrivals.smallestNumberOfTransfers(stop);
            }
        };
    }

    @Override
    public boolean isDestinationReached() {
        return !this.paths.isEmpty();
    }
}

