/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.multicriteria;

import java.util.List;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.raptor.util.paretoset.ParetoSetEventListener;

class CalculateTransferToDestination<T extends RaptorTripSchedule>
implements ParetoSetEventListener<ArrivalView<T>> {
    private final List<RaptorAccessEgress> egressPaths;
    private final DestinationArrivalPaths<T> destinationArrivals;

    CalculateTransferToDestination(List<RaptorAccessEgress> egressPaths, DestinationArrivalPaths<T> destinationArrivals) {
        this.egressPaths = egressPaths;
        this.destinationArrivals = destinationArrivals;
    }

    @Override
    public void notifyElementAccepted(ArrivalView<T> newElement) {
        switch (newElement.arrivedBy()) {
            case TRANSIT: {
                this.addOnBoardStopArrivalToDestination(newElement);
                break;
            }
            case TRANSFER: {
                this.addOnStreetArrivalToDestination(newElement);
                break;
            }
            case ACCESS: {
                if (newElement.arrivedOnBoard()) {
                    this.addOnBoardStopArrivalToDestination(newElement);
                    break;
                }
                this.addOnStreetArrivalToDestination(newElement);
                break;
            }
            case EGRESS: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void addOnBoardStopArrivalToDestination(ArrivalView<T> newElement) {
        for (RaptorAccessEgress egress : this.egressPaths) {
            this.destinationArrivals.add(newElement, egress);
        }
    }

    private void addOnStreetArrivalToDestination(ArrivalView<T> newElement) {
        for (RaptorAccessEgress egress : this.egressPaths) {
            if (!egress.stopReachedOnBoard()) continue;
            this.destinationArrivals.add(newElement, egress);
        }
    }
}

