/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor;

import java.util.Collection;
import org.opentripplanner.raptor.api.debug.RaptorTimers;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripPattern;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorker;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerResult;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerState;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoundProvider;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoutingStrategy;
import org.opentripplanner.raptor.rangeraptor.internalapi.SlackProvider;
import org.opentripplanner.raptor.rangeraptor.lifecycle.LifeCycleEventPublisher;
import org.opentripplanner.raptor.rangeraptor.transit.AccessPaths;
import org.opentripplanner.raptor.rangeraptor.transit.RaptorTransitCalculator;
import org.opentripplanner.raptor.rangeraptor.transit.RoundTracker;
import org.opentripplanner.raptor.spi.IntIterator;
import org.opentripplanner.raptor.spi.RaptorConstrainedBoardingSearch;
import org.opentripplanner.raptor.spi.RaptorRoute;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;

public final class DefaultRangeRaptorWorker<T extends RaptorTripSchedule>
implements RaptorWorker<T> {
    private final RoutingStrategy<T> transitWorker;
    private final RaptorWorkerState<T> state;
    private final RoundTracker roundTracker;
    private final RaptorTransitDataProvider<T> transitData;
    private final SlackProvider slackProvider;
    private final RaptorTransitCalculator<T> calculator;
    private final RaptorTimers timers;
    private final AccessPaths accessPaths;
    private final LifeCycleEventPublisher lifeCycle;
    private final int minNumberOfRounds;
    private final boolean enableTransferConstraints;
    private int iterationDepartureTime;

    public DefaultRangeRaptorWorker(RaptorWorkerState<T> state, RoutingStrategy<T> transitWorker, RaptorTransitDataProvider<T> transitData, SlackProvider slackProvider, AccessPaths accessPaths, RoundProvider roundProvider, RaptorTransitCalculator<T> calculator, LifeCycleEventPublisher lifeCyclePublisher, RaptorTimers timers, boolean enableTransferConstraints) {
        this.transitWorker = transitWorker;
        this.state = state;
        this.transitData = transitData;
        this.slackProvider = slackProvider;
        this.calculator = calculator;
        this.timers = timers;
        this.accessPaths = accessPaths;
        this.minNumberOfRounds = accessPaths.calculateMaxNumberOfRides();
        this.enableTransferConstraints = enableTransferConstraints;
        this.roundTracker = (RoundTracker)roundProvider;
        this.lifeCycle = lifeCyclePublisher;
    }

    @Override
    public RaptorWorkerResult<T> route() {
        this.timers.route(() -> {
            this.lifeCycle.notifyRouteSearchStart(this.calculator.searchForward());
            this.transitData.setup();
            IntIterator it = this.calculator.rangeRaptorMinutes();
            while (it.hasNext()) {
                this.iterationDepartureTime = it.next();
                this.lifeCycle.setupIteration(this.iterationDepartureTime);
                this.runRaptorForMinute();
            }
        });
        return this.state.results();
    }

    private void runRaptorForMinute() {
        this.findAccessOnStreetForRound();
        while (this.hasMoreRounds()) {
            this.lifeCycle.prepareForNextRound(this.roundTracker.nextRound());
            this.findTransitForRound();
            this.findAccessOnBoardForRound();
            this.findTransfersForRound();
            this.lifeCycle.roundComplete(this.state.isDestinationReachedInCurrentRound());
            this.findAccessOnStreetForRound();
        }
        this.lifeCycle.iterationComplete();
    }

    private boolean hasMoreRounds() {
        if (this.round() < this.minNumberOfRounds) {
            return true;
        }
        return this.state.isNewRoundAvailable() && this.roundTracker.hasMoreRounds();
    }

    private void findTransitForRound() {
        this.timers.findTransitForRound(() -> {
            IntIterator stops = this.state.stopsTouchedPreviousRound();
            IntIterator routeIndexIterator = this.transitData.routeIndexIterator(stops);
            while (routeIndexIterator.hasNext()) {
                int routeIndex = routeIndexIterator.next();
                RaptorRoute<T> route = this.transitData.getRouteForIndex(routeIndex);
                RaptorTripPattern pattern = route.pattern();
                RaptorConstrainedBoardingSearch<T> txSearch = this.enableTransferConstraints ? this.calculator.transferConstraintsSearch(this.transitData, routeIndex) : null;
                int alightSlack = this.slackProvider.alightSlack(pattern.slackIndex());
                int boardSlack = this.slackProvider.boardSlack(pattern.slackIndex());
                this.transitWorker.prepareForTransitWith(route);
                IntIterator stop = this.calculator.patternStopIterator(pattern.numberOfStopsInPattern());
                while (stop.hasNext()) {
                    int stopPos = stop.next();
                    int stopIndex = pattern.stopIndex(stopPos);
                    if (this.calculator.alightingPossibleAt(pattern, stopPos)) {
                        if (this.enableTransferConstraints && txSearch.transferExistSourceStop(stopPos)) {
                            this.transitWorker.alightConstrainedTransferExist(stopIndex, stopPos, alightSlack);
                        } else {
                            this.transitWorker.alightOnlyRegularTransferExist(stopIndex, stopPos, alightSlack);
                        }
                    }
                    if (!this.calculator.boardingPossibleAt(pattern, stopPos) || !this.state.isStopReachedInPreviousRound(stopIndex)) continue;
                    if (this.enableTransferConstraints && txSearch.transferExistTargetStop(stopPos)) {
                        this.transitWorker.boardWithConstrainedTransfer(stopIndex, stopPos, boardSlack, txSearch);
                        continue;
                    }
                    this.transitWorker.boardWithRegularTransfer(stopIndex, stopPos, boardSlack);
                }
            }
            this.lifeCycle.transitsForRoundComplete();
        });
    }

    private void findTransfersForRound() {
        this.timers.findTransfersForRound(() -> {
            IntIterator it = this.state.stopsTouchedByTransitCurrentRound();
            while (it.hasNext()) {
                int fromStop = it.next();
                this.state.transferToStops(fromStop, this.calculator.getTransfers(this.transitData, fromStop));
            }
            this.lifeCycle.transfersForRoundComplete();
        });
    }

    private void findAccessOnStreetForRound() {
        this.addAccessPaths((Collection)this.accessPaths.arrivedOnStreetByNumOfRides().get(this.round()));
    }

    private void findAccessOnBoardForRound() {
        this.addAccessPaths((Collection)this.accessPaths.arrivedOnBoardByNumOfRides().get(this.round()));
    }

    private void addAccessPaths(Collection<RaptorAccessEgress> accessPaths) {
        if (accessPaths == null) {
            return;
        }
        for (RaptorAccessEgress it : accessPaths) {
            int departureTime = this.calculator.departureTime(it, this.iterationDepartureTime);
            if (departureTime == -1999000000) continue;
            this.transitWorker.setAccessToStop(it, departureTime);
        }
    }

    private int round() {
        return this.roundTracker.round();
    }
}

