/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.path;

import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorConstrainedTransfer;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.AccessPathLeg;
import org.opentripplanner.raptor.api.path.PathStringBuilder;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.path.Path;
import org.opentripplanner.raptor.path.PathBuilderLeg;
import org.opentripplanner.raptor.spi.BoardAndAlightTime;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.raptor.spi.RaptorSlackProvider;

public abstract class PathBuilder<T extends RaptorTripSchedule> {
    private final RaptorSlackProvider slackProvider;
    @Nullable
    private final RaptorCostCalculator<T> costCalculator;
    @Nullable
    private final RaptorStopNameResolver stopNameResolver;
    @Nullable
    private final RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch;
    private PathBuilderLeg<T> head = null;
    private PathBuilderLeg<T> tail = null;
    protected final int iterationDepartureTime;

    protected PathBuilder(PathBuilder<T> other) {
        this(other.slackProvider, other.iterationDepartureTime, other.costCalculator, other.stopNameResolver, other.transferConstraintsSearch);
        this.head = other.head == null ? null : other.head.mutate();
        this.tail = this.head == null ? null : this.last(this.head);
    }

    protected PathBuilder(RaptorSlackProvider slackProvider, int iterationDepartureTime, @Nullable RaptorCostCalculator<T> costCalculator, @Nullable RaptorStopNameResolver stopNameResolver, @Nullable RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch) {
        this.slackProvider = slackProvider;
        this.costCalculator = costCalculator;
        this.stopNameResolver = stopNameResolver;
        this.transferConstraintsSearch = transferConstraintsSearch;
        this.iterationDepartureTime = iterationDepartureTime;
    }

    public static <T extends RaptorTripSchedule> PathBuilder<T> headPathBuilder(RaptorSlackProvider slackProvider, int iterationDepartureTime, @Nullable RaptorCostCalculator<T> costCalculator, @Nullable RaptorStopNameResolver stopNameResolver, @Nullable RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch) {
        return new HeadPathBuilder<T>(slackProvider, costCalculator, iterationDepartureTime, stopNameResolver, transferConstraintsSearch);
    }

    public static <T extends RaptorTripSchedule> PathBuilder<T> tailPathBuilder(RaptorSlackProvider slackProvider, int iterationDepartureTime, @Nullable RaptorCostCalculator<T> costCalculator, @Nullable RaptorStopNameResolver stopNameResolver, @Nullable RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch) {
        return new TailPathBuilder<T>(slackProvider, costCalculator, iterationDepartureTime, stopNameResolver, transferConstraintsSearch);
    }

    protected RaptorSlackProvider slackProvider() {
        return this.slackProvider;
    }

    @Nullable
    protected RaptorCostCalculator<T> costCalculator() {
        return this.costCalculator;
    }

    @Nullable
    protected RaptorStopNameResolver stopNameResolver() {
        return this.stopNameResolver;
    }

    public void access(RaptorAccessEgress access) {
        this.add(PathBuilderLeg.accessLeg(access));
    }

    public void transit(T trip, BoardAndAlightTime times) {
        this.add(PathBuilderLeg.transitLeg(trip, times));
    }

    public void transit(T trip, BoardAndAlightTime times, RaptorConstrainedTransfer txConstrainedTransferAfter) {
        this.add(PathBuilderLeg.transitLeg(trip, times, txConstrainedTransferAfter));
    }

    public void transfer(RaptorTransfer transfer, int toStop) {
        this.add(PathBuilderLeg.transferLeg(transfer, toStop));
    }

    public void egress(RaptorAccessEgress egress) {
        this.add(PathBuilderLeg.egress(egress));
    }

    public RaptorPath<T> build() {
        this.updateAggregatedFields();
        return new Path<T>(this.iterationDepartureTime, this.createPathLegs(this.costCalculator, this.slackProvider));
    }

    public String toString() {
        PathStringBuilder builder = new PathStringBuilder(this.stopNameResolver);
        this.legsAsStream().forEach(it -> it.toString(builder));
        return builder.toString();
    }

    public Stream<PathBuilderLeg<T>> legsAsStream() {
        return Stream.iterate(this.head, Objects::nonNull, PathBuilderLeg::next);
    }

    public PathBuilderLeg<T> head() {
        return this.head;
    }

    public PathBuilderLeg<T> tail() {
        return this.tail;
    }

    protected abstract void add(PathBuilderLeg<T> var1);

    protected void updateAggregatedFields() {
        this.timeShiftAllStreetLegs();
        this.insertConstrainedTransfers();
    }

    protected void addTail(PathBuilderLeg<T> newLeg) {
        if (this.head == null) {
            this.tail = newLeg;
            this.head = this.tail;
        } else {
            this.tail.setNext(newLeg);
            newLeg.setPrev(this.tail);
            this.tail = newLeg;
        }
    }

    protected void addHead(PathBuilderLeg<T> newLeg) {
        if (this.head == null) {
            this.tail = newLeg;
            this.head = this.tail;
        } else {
            newLeg.setNext(this.head);
            this.head.setPrev(newLeg);
            this.head = newLeg;
        }
    }

    protected AccessPathLeg<T> createPathLegs(RaptorCostCalculator<T> costCalculator, RaptorSlackProvider slackProvider) {
        return this.head.createAccessPathLeg(costCalculator, slackProvider);
    }

    protected boolean skipCostCalc() {
        return this.costCalculator == null;
    }

    private void timeShiftAllStreetLegs() {
        this.legsAsStream().forEach(leg -> leg.timeShiftThisAndNextLeg(this.slackProvider, this.iterationDepartureTime));
    }

    private void insertConstrainedTransfers() {
        if (this.transferConstraintsSearch == null) {
            return;
        }
        PathBuilderLeg<T> prev = this.head.nextTransitLeg();
        if (prev == null) {
            return;
        }
        for (PathBuilderLeg<T> curr = prev.nextTransitLeg(); curr != null; curr = curr.nextTransitLeg()) {
            this.addTransferConstraints(prev, curr);
            prev = curr;
        }
    }

    private void addTransferConstraints(PathBuilderLeg<T> from, PathBuilderLeg<T> to) {
        RaptorConstrainedTransfer tx = this.transferConstraintsSearch.findConstrainedTransfer(from.trip(), from.toStopPos(), to.trip(), to.fromStopPos());
        if (tx != null) {
            from.setConstrainedTransferAfterLeg(tx);
        }
    }

    private PathBuilderLeg<T> last(PathBuilderLeg<T> head) {
        return head.next() == null ? head : this.last(head.next());
    }

    private static class HeadPathBuilder<T extends RaptorTripSchedule>
    extends PathBuilder<T> {
        private HeadPathBuilder(RaptorSlackProvider slackProvider, RaptorCostCalculator<T> costCalculator, int iterationDepartureTime, @Nullable RaptorStopNameResolver stopNameResolver, @Nullable RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch) {
            super(slackProvider, iterationDepartureTime, costCalculator, stopNameResolver, transferConstraintsSearch);
        }

        @Override
        protected void add(PathBuilderLeg<T> newLeg) {
            this.addHead(newLeg);
        }
    }

    private static class TailPathBuilder<T extends RaptorTripSchedule>
    extends PathBuilder<T> {
        private TailPathBuilder(RaptorSlackProvider slackProvider, RaptorCostCalculator<T> costCalculator, int iterationDepartureTime, @Nullable RaptorStopNameResolver stopNameResolver, @Nullable RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch) {
            super(slackProvider, iterationDepartureTime, costCalculator, stopNameResolver, transferConstraintsSearch);
        }

        @Override
        protected void add(PathBuilderLeg<T> newLeg) {
            this.addTail(newLeg);
        }
    }
}

