/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.path;

import java.util.Objects;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.PathLeg;

public final class TransferPathLeg<T extends RaptorTripSchedule>
implements PathLeg<T> {
    private final int fromStop;
    private final int fromTime;
    private final int toStop;
    private final int toTime;
    private final int cost;
    private final RaptorTransfer transfer;
    private final PathLeg<T> next;

    public TransferPathLeg(int fromStop, int fromTime, int toTime, int generalizedCost, RaptorTransfer transfer, PathLeg<T> next) {
        this.fromStop = fromStop;
        this.fromTime = fromTime;
        this.toStop = transfer.stop();
        this.toTime = toTime;
        this.cost = generalizedCost;
        this.transfer = transfer;
        this.next = next;
    }

    public RaptorTransfer transfer() {
        return this.transfer;
    }

    @Override
    public int fromTime() {
        return this.fromTime;
    }

    @Override
    public int fromStop() {
        return this.fromStop;
    }

    @Override
    public int toTime() {
        return this.toTime;
    }

    @Override
    public int toStop() {
        return this.toStop;
    }

    @Override
    public int generalizedCost() {
        return this.cost;
    }

    @Override
    public boolean isTransferLeg() {
        return true;
    }

    @Override
    public PathLeg<T> nextLeg() {
        return this.next;
    }

    public int hashCode() {
        return Objects.hash(this.toStop, this.toTime, this.fromStop, this.fromTime, this.next);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferPathLeg that = (TransferPathLeg)o;
        return this.toStop == that.toStop && this.toTime == that.toTime && this.fromStop == that.fromStop && this.fromTime == that.fromTime && Objects.equals(this.next, that.next);
    }

    public String toString() {
        return "Walk " + this.asString(this.toStop());
    }
}

