/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.path;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.RelaxFunction;
import org.opentripplanner.raptor.api.path.AccessPathLeg;
import org.opentripplanner.raptor.api.path.EgressPathLeg;
import org.opentripplanner.raptor.api.path.PathLeg;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.api.path.TransitPathLeg;

public interface RaptorPath<T extends RaptorTripSchedule>
extends Comparable<RaptorPath<T>> {
    public int rangeRaptorIterationDepartureTime();

    public int startTime();

    public int endTime();

    public int durationInSeconds();

    public int numberOfTransfers();

    public int numberOfTransfersExAccessEgress();

    public int c1();

    @Nullable
    public AccessPathLeg<T> accessLeg();

    @Nullable
    public EgressPathLeg<T> egressLeg();

    public List<Integer> listStops();

    public int waitTime();

    public Stream<PathLeg<T>> legStream();

    public Stream<TransitPathLeg<T>> transitLegs();

    public String toStringDetailed(RaptorStopNameResolver var1);

    public String toString(RaptorStopNameResolver var1);

    @Override
    default public int compareTo(RaptorPath<T> other) {
        int c = this.endTime() - other.endTime();
        if (c != 0) {
            return c;
        }
        c = other.startTime() - this.startTime();
        if (c != 0) {
            return c;
        }
        c = this.c1() - other.c1();
        if (c != 0) {
            return c;
        }
        c = this.numberOfTransfers() - other.numberOfTransfers();
        return c;
    }

    default public boolean isUnknownPath() {
        return false;
    }

    public static <T extends RaptorTripSchedule> boolean compareArrivalTime(RaptorPath<T> l, RaptorPath<T> r) {
        return l.endTime() < r.endTime();
    }

    public static <T extends RaptorTripSchedule> boolean compareDepartureTime(RaptorPath<T> l, RaptorPath<T> r) {
        return l.startTime() > r.startTime();
    }

    public static <T extends RaptorTripSchedule> boolean compareIterationDepartureTime(RaptorPath<T> l, RaptorPath<T> r) {
        return l.rangeRaptorIterationDepartureTime() > r.rangeRaptorIterationDepartureTime();
    }

    public static <T extends RaptorTripSchedule> boolean compareDuration(RaptorPath<T> l, RaptorPath<T> r) {
        return l.durationInSeconds() < r.durationInSeconds();
    }

    public static <T extends RaptorTripSchedule> boolean compareNumberOfTransfers(RaptorPath<T> l, RaptorPath<T> r) {
        return l.numberOfTransfers() < r.numberOfTransfers();
    }

    public static <T extends RaptorTripSchedule> boolean compareC1(RaptorPath<T> l, RaptorPath<T> r) {
        return l.c1() < r.c1();
    }

    public static <T extends RaptorTripSchedule> boolean compareC1(RelaxFunction relax, RaptorPath<T> l, RaptorPath<T> r) {
        return l.c1() < relax.relax(r.c1());
    }
}

