/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.path;

import java.time.ZonedDateTime;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.opentripplanner.framework.lang.OtpNumberFormat;
import org.opentripplanner.framework.time.DurationUtils;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;

public class PathStringBuilder {
    private final RaptorStopNameResolver stopNameResolver;
    private final StringBuilder buf = new StringBuilder();
    private boolean addPadding = false;

    public PathStringBuilder(@Nullable RaptorStopNameResolver stopNameResolver) {
        this.stopNameResolver = RaptorStopNameResolver.nullSafe(stopNameResolver);
    }

    public PathStringBuilder stop(int stopIndex) {
        return this.stop(this.stopNameResolver.apply(stopIndex));
    }

    public PathStringBuilder stop(String stop) {
        return this.legSep().text(stop);
    }

    public PathStringBuilder walk(int duration) {
        return this.legSep().text("Walk").duration(duration);
    }

    public PathStringBuilder pickupRental(String stop, int duration) {
        return this.legSep().text(stop).text("Rental").duration(duration);
    }

    public PathStringBuilder accessEgress(RaptorAccessEgress leg) {
        if (leg.isFree()) {
            return this;
        }
        return this.legSep().text(leg.asString(false));
    }

    public PathStringBuilder transit(String description, int fromTime, int toTime) {
        return this.legSep().text(description).time(fromTime, toTime);
    }

    public PathStringBuilder transit(String modeName, String trip, ZonedDateTime fromTime, ZonedDateTime toTime) {
        return this.legSep().text(modeName).text(trip).time(fromTime, toTime);
    }

    public PathStringBuilder street(String modeName, ZonedDateTime fromTime, ZonedDateTime toTime) {
        return this.legSep().text(modeName).time(fromTime, toTime);
    }

    public PathStringBuilder timeAndCostCentiSec(int fromTime, int toTime, int generalizedCost) {
        return this.time(fromTime, toTime).generalizedCostSentiSec(generalizedCost);
    }

    public PathStringBuilder generalizedCostSentiSec(int cost) {
        return this.costCentiSec(cost, 0, null);
    }

    public PathStringBuilder costCentiSec(int generalizedCostCents, int defaultValue, String unit) {
        if (generalizedCostCents == defaultValue) {
            return this;
        }
        String costText = OtpNumberFormat.formatCostCenti(generalizedCostCents);
        return unit != null ? this.text(costText + unit) : this.text(costText);
    }

    public PathStringBuilder duration(int duration) {
        return this.text(DurationUtils.durationToStr(duration));
    }

    public PathStringBuilder time(int from, int to) {
        return this.time(from).time(to);
    }

    public PathStringBuilder time(int time) {
        return time != -1999000000 ? this.text(TimeUtils.timeToStrCompact(time)) : this;
    }

    public PathStringBuilder numberOfTransfers(int nTransfers) {
        return nTransfers != -1999000000 ? this.text(nTransfers + "tx") : this;
    }

    public PathStringBuilder summary(int generalizedCostCents) {
        return this.summaryStart().generalizedCostSentiSec(generalizedCostCents).summaryEnd();
    }

    public PathStringBuilder summary(int startTime, int endTime, int nTransfers, int generalizedCostCents) {
        return this.summary(startTime, endTime, nTransfers, generalizedCostCents, null);
    }

    public PathStringBuilder summary(int startTime, int endTime, int nTransfers, int generalizedCostCents, @Nullable Consumer<PathStringBuilder> appendToSummary) {
        this.summaryStart().time(startTime, endTime).duration(Math.abs(endTime - startTime)).numberOfTransfers(nTransfers).generalizedCostSentiSec(generalizedCostCents);
        if (appendToSummary != null) {
            appendToSummary.accept(this);
        }
        return this.summaryEnd();
    }

    public String toString() {
        return this.buf.toString();
    }

    private PathStringBuilder summaryStart() {
        this.text("[");
        this.addPadding = false;
        return this;
    }

    private PathStringBuilder summaryEnd() {
        this.buf.append(']');
        return this;
    }

    private PathStringBuilder time(ZonedDateTime from, ZonedDateTime to) {
        return this.text(TimeUtils.timeToStrCompact(from)).text(TimeUtils.timeToStrCompact(to));
    }

    private PathStringBuilder legSep() {
        if (this.addPadding) {
            this.text("~");
        }
        return this;
    }

    private PathStringBuilder sep() {
        if (this.addPadding) {
            this.buf.append(' ');
        }
        return this;
    }

    public PathStringBuilder text(String text) {
        this.sep();
        this.buf.append(text);
        this.addPadding = true;
        return this;
    }
}

