/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.path;

import java.util.Objects;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.PathLeg;
import org.opentripplanner.raptor.api.path.TransitPathLeg;

public final class EgressPathLeg<T extends RaptorTripSchedule>
implements PathLeg<T> {
    private final RaptorAccessEgress egress;
    private final int fromTime;
    private final int toTime;
    private final int generalizedCost;

    public EgressPathLeg(RaptorAccessEgress egress, int fromTime, int toTime, int generalizedCost) {
        this.egress = egress;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.generalizedCost = generalizedCost;
    }

    @Override
    public int fromTime() {
        return this.fromTime;
    }

    @Override
    public int fromStop() {
        return this.egress.stop();
    }

    @Override
    public int toTime() {
        return this.toTime;
    }

    @Override
    public int generalizedCost() {
        return this.generalizedCost;
    }

    @Override
    public boolean isEgressLeg() {
        return true;
    }

    @Override
    public TransitPathLeg<T> nextLeg() {
        throw new UnsupportedOperationException("The egress leg is the last leg in a path. Use isEgressLeg() to identify last leg.");
    }

    public RaptorAccessEgress egress() {
        return this.egress;
    }

    public int hashCode() {
        return Objects.hash(this.fromStop(), this.fromTime, this.toTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EgressPathLeg that = (EgressPathLeg)o;
        return this.fromStop() == that.fromStop() && this.fromTime == that.fromTime && this.toTime == that.toTime;
    }

    public String toString() {
        return "Egress " + this.asString();
    }
}

