/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.model;

import java.time.Duration;
import java.util.Locale;
import java.util.Objects;
import org.opentripplanner.framework.lang.OtpNumberFormat;
import org.opentripplanner.raptor.api.model.RelaxFunction;

public final class GeneralizedCostRelaxFunction
implements RelaxFunction {
    private static final int FOUR_HOURS = (int)Duration.ofHours(4L).toSeconds();
    public static final int MIN_SLACK = 0;
    public static final int MAX_SLACK = FOUR_HOURS * 100;
    private static final int RATIO_RESOLUTION = 256;
    public static final double MIN_RATIO = 1.0;
    public static final double MAX_RATIO = 4.0;
    private final int normalizedRatio;
    private final int slack;

    private GeneralizedCostRelaxFunction(int normalizedRatio, int slack) {
        this.normalizedRatio = normalizedRatio;
        this.slack = slack;
    }

    public static RelaxFunction of(double ratio, int slack) {
        GeneralizedCostRelaxFunction.assertRatioInRange(ratio);
        GeneralizedCostRelaxFunction.assertSlackInRange(slack);
        int normalizedRatio = GeneralizedCostRelaxFunction.normalizedRatio(ratio);
        if (GeneralizedCostRelaxFunction.isNormal(normalizedRatio, slack)) {
            return NORMAL;
        }
        return new GeneralizedCostRelaxFunction(normalizedRatio, slack);
    }

    public static RelaxFunction of(double ratio) {
        return GeneralizedCostRelaxFunction.of(ratio, 0);
    }

    @Override
    public int relax(int value) {
        return value * this.normalizedRatio / 256 + this.slack;
    }

    public String toString() {
        return String.format(Locale.ROOT, "f(x) = %.2f * x + %s", (double)this.normalizedRatio / 256.0, OtpNumberFormat.formatTwoDecimals((double)this.slack / 100.0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneralizedCostRelaxFunction that = (GeneralizedCostRelaxFunction)o;
        return this.normalizedRatio == that.normalizedRatio && this.slack == that.slack;
    }

    public int hashCode() {
        return Objects.hash(this.normalizedRatio, this.slack);
    }

    private static int normalizedRatio(double ratio) {
        return (int)Math.round(ratio * 256.0);
    }

    private static boolean isNormal(int normalizedRatio, int slack) {
        return normalizedRatio == 256 && slack == 0;
    }

    private static void assertSlackInRange(int slack) {
        if (slack < 0 || slack > MAX_SLACK) {
            throw new IllegalArgumentException("Cost slack is not in range: %d not in [%d..%d]".formatted(slack, 0, MAX_SLACK));
        }
    }

    private static void assertRatioInRange(double ratio) {
        if (ratio < 1.0 || ratio > 4.0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cost ratio is not in range: %.2f not in [%.1f..%.1f]", ratio, 1.0, 4.0));
        }
    }
}

