/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.wayproperty.specifier;

import java.util.Arrays;
import java.util.List;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.openstreetmap.wayproperty.specifier.Condition;
import org.opentripplanner.openstreetmap.wayproperty.specifier.ExactMatchSpecifier;
import org.opentripplanner.openstreetmap.wayproperty.specifier.OsmSpecifier;

public class LogicalOrSpecifier
implements OsmSpecifier {
    private final List<ExactMatchSpecifier> subSpecs;

    public LogicalOrSpecifier(ExactMatchSpecifier ... specifiers) {
        this.subSpecs = Arrays.asList(specifiers);
    }

    public LogicalOrSpecifier(Condition ... conditions) {
        this.subSpecs = Arrays.stream(conditions).map(xva$0 -> new ExactMatchSpecifier((Condition)xva$0)).toList();
    }

    public LogicalOrSpecifier(String ... specs) {
        this.subSpecs = Arrays.stream(specs).map(ExactMatchSpecifier::new).toList();
    }

    @Override
    public OsmSpecifier.Scores matchScores(OSMWithTags way) {
        return OsmSpecifier.Scores.of(this.matchScore(way));
    }

    @Override
    public int matchScore(OSMWithTags way) {
        boolean oneMatchesExactly = this.subSpecs.stream().anyMatch(subspec -> subspec.allTagsMatch(way));
        if (oneMatchesExactly) {
            return 1;
        }
        return 0;
    }
}

