/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.wayproperty;

import org.opentripplanner.openstreetmap.wayproperty.SafetyFeatures;
import org.opentripplanner.openstreetmap.wayproperty.WayProperties;
import org.opentripplanner.street.model.StreetTraversalPermission;

public class WayPropertiesBuilder {
    private final StreetTraversalPermission permission;
    private SafetyFeatures bicycleSafetyFeatures = null;
    private SafetyFeatures walkSafetyFeatures = null;

    public WayPropertiesBuilder(StreetTraversalPermission permission) {
        this.permission = permission;
    }

    public WayPropertiesBuilder(WayProperties defaultProperties) {
        this.permission = defaultProperties.getPermission();
        this.bicycleSafetyFeatures = defaultProperties.getBicycleSafetyFeatures();
        this.walkSafetyFeatures = defaultProperties.getWalkSafetyFeatures();
    }

    public WayPropertiesBuilder bicycleSafety(double bicycleSafety) {
        this.bicycleSafetyFeatures = new SafetyFeatures(bicycleSafety, bicycleSafety);
        return this;
    }

    public WayPropertiesBuilder bicycleSafety(double bicycleSafety, double bicycleSafetyBack) {
        this.bicycleSafetyFeatures = new SafetyFeatures(bicycleSafety, bicycleSafetyBack);
        return this;
    }

    public WayPropertiesBuilder walkSafety(double walkSafety) {
        this.walkSafetyFeatures = new SafetyFeatures(walkSafety, walkSafety);
        return this;
    }

    public WayPropertiesBuilder walkSafety(double walkSafety, double walkSafetyBack) {
        this.walkSafetyFeatures = new SafetyFeatures(walkSafety, walkSafetyBack);
        return this;
    }

    public StreetTraversalPermission getPermission() {
        return this.permission;
    }

    public SafetyFeatures getBicycleSafetyFeatures() {
        return this.bicycleSafetyFeatures;
    }

    public SafetyFeatures getWalkSafetyFeatures() {
        return this.walkSafetyFeatures;
    }

    public WayProperties build() {
        return new WayProperties(this);
    }

    public static WayPropertiesBuilder withModes(StreetTraversalPermission p) {
        return new WayPropertiesBuilder(p);
    }
}

