/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.wayproperty;

import java.util.Objects;
import org.opentripplanner.openstreetmap.wayproperty.SafetyFeatures;
import org.opentripplanner.openstreetmap.wayproperty.WayPropertiesBuilder;
import org.opentripplanner.street.model.StreetTraversalPermission;

public class WayProperties {
    private final StreetTraversalPermission permission;
    private final SafetyFeatures bicycleSafetyFeatures;
    private final SafetyFeatures walkSafetyFeatures;

    public WayProperties(WayPropertiesBuilder wayPropertiesBuilder) {
        this.permission = wayPropertiesBuilder.getPermission();
        this.bicycleSafetyFeatures = wayPropertiesBuilder.getBicycleSafetyFeatures();
        this.walkSafetyFeatures = wayPropertiesBuilder.getWalkSafetyFeatures();
    }

    public SafetyFeatures getBicycleSafetyFeatures() {
        return this.bicycleSafetyFeatures;
    }

    public SafetyFeatures getWalkSafetyFeatures() {
        return this.walkSafetyFeatures;
    }

    public StreetTraversalPermission getPermission() {
        return this.permission;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bicycleSafetyFeatures, this.walkSafetyFeatures, this.permission});
    }

    public boolean equals(Object o) {
        if (o instanceof WayProperties) {
            WayProperties other = (WayProperties)o;
            return Objects.equals(this.bicycleSafetyFeatures, other.bicycleSafetyFeatures) && Objects.equals(this.walkSafetyFeatures, other.walkSafetyFeatures) && this.permission == other.permission;
        }
        return false;
    }

    public WayPropertiesBuilder mutate() {
        return new WayPropertiesBuilder(this);
    }
}

