/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.tagmapping;

import java.util.function.BiFunction;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.openstreetmap.tagmapping.DefaultMapper;
import org.opentripplanner.openstreetmap.tagmapping.OsmTagMapper;
import org.opentripplanner.openstreetmap.wayproperty.MixinPropertiesBuilder;
import org.opentripplanner.openstreetmap.wayproperty.WayProperties;
import org.opentripplanner.openstreetmap.wayproperty.WayPropertiesBuilder;
import org.opentripplanner.openstreetmap.wayproperty.WayPropertySet;
import org.opentripplanner.openstreetmap.wayproperty.specifier.BestMatchSpecifier;
import org.opentripplanner.openstreetmap.wayproperty.specifier.Condition;
import org.opentripplanner.openstreetmap.wayproperty.specifier.ExactMatchSpecifier;
import org.opentripplanner.openstreetmap.wayproperty.specifier.LogicalOrSpecifier;
import org.opentripplanner.openstreetmap.wayproperty.specifier.OsmSpecifier;
import org.opentripplanner.street.model.StreetTraversalPermission;

class NorwayMapper
implements OsmTagMapper {
    NorwayMapper() {
    }

    @Override
    public void populateProperties(WayPropertySet props) {
        Condition.EqualsAnyIn hasSidewalk = new Condition.EqualsAnyIn("sidewalk", "yes", "left", "right", "both");
        Condition.Equals hasPrefixSidewalk = new Condition.Equals("sidewalk", "yes");
        props.setDefaultWalkSafetyForPermission((permission, speedLimit, way) -> switch (permission) {
            default -> throw new IncompatibleClassChangeError();
            case StreetTraversalPermission.ALL, StreetTraversalPermission.PEDESTRIAN_AND_CAR -> {
                if (hasSidewalk.isMatch((OSMWithTags)way) || hasPrefixSidewalk.isLeftMatch((OSMWithTags)way) || hasPrefixSidewalk.isRightMatch((OSMWithTags)way)) {
                    yield 1.1;
                }
                if (speedLimit.floatValue() >= 25.0f) {
                    yield 3.0;
                }
                if (speedLimit.floatValue() >= 16.6f) {
                    yield 1.9;
                }
                if (speedLimit.floatValue() >= 11.1f) {
                    yield 1.6;
                }
                yield 1.45;
            }
            case StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE -> 1.15;
            case StreetTraversalPermission.PEDESTRIAN -> 1.0;
            case StreetTraversalPermission.BICYCLE_AND_CAR, StreetTraversalPermission.BICYCLE, StreetTraversalPermission.CAR, StreetTraversalPermission.NONE -> 3.0;
        });
        double cycleSafetyVeryHighTraffic = 10.0;
        double cycleSafetyHighTraffic = 3.75;
        double cycleSafetyMediumHighTraffic = 3.43;
        double cycleSafetyMediumTraffic = 2.5;
        double cycleSafetyMediumLowTraffic = 2.37;
        double cycleSafetyLowTraffic = 1.83;
        double cycleSafetyVeryLowTraffic = 1.57;
        Condition.EqualsAnyIn isTrunkOrPrimary = new Condition.EqualsAnyIn("highway", "trunk", "trunk_link", "primary", "primary_link");
        Condition.EqualsAnyIn isSecondaryHighway = new Condition.EqualsAnyIn("highway", "secondary", "secondary_link");
        Condition.EqualsAnyIn isTertiaryHighway = new Condition.EqualsAnyIn("highway", "tertiary", "tertiary_link");
        Condition.EqualsAnyIn isClassifiedRoad = new Condition.EqualsAnyIn("highway", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link");
        Condition.EqualsAnyIn isClassifiedOrUnclassifiedRoad = new Condition.EqualsAnyIn("highway", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified");
        Condition.EqualsAnyIn isNormalRoad = new Condition.EqualsAnyIn("highway", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "residential");
        BiFunction<Float, OSMWithTags, Double> cycleSafetyHighway = (speedLimit, way) -> {
            if (way.isPedestrianExplicitlyDenied()) {
                return cycleSafetyVeryHighTraffic;
            }
            if (speedLimit.floatValue() >= 25.0f) {
                return cycleSafetyVeryHighTraffic;
            }
            if (speedLimit.floatValue() >= 19.4f) {
                if (isTrunkOrPrimary.isMatch((OSMWithTags)way)) {
                    return cycleSafetyHighTraffic;
                }
                return cycleSafetyMediumHighTraffic;
            }
            if (speedLimit.floatValue() >= 11.1f) {
                if (isTrunkOrPrimary.isMatch((OSMWithTags)way)) {
                    return speedLimit.floatValue() >= 16.6f ? cycleSafetyMediumHighTraffic : cycleSafetyMediumTraffic;
                }
                if (isSecondaryHighway.isMatch((OSMWithTags)way)) {
                    return speedLimit.floatValue() >= 16.6f ? cycleSafetyMediumTraffic : cycleSafetyMediumLowTraffic;
                }
                if (isTertiaryHighway.isMatch((OSMWithTags)way)) {
                    return speedLimit.floatValue() >= 13.8f ? cycleSafetyMediumLowTraffic : cycleSafetyLowTraffic;
                }
            }
            if (this.isMotorVehicleThroughTrafficExplicitlyDisallowed((OSMWithTags)way)) {
                return cycleSafetyVeryLowTraffic;
            }
            return cycleSafetyLowTraffic;
        };
        props.setDefaultBicycleSafetyForPermission((permission, speedLimit, way) -> switch (permission) {
            default -> throw new IncompatibleClassChangeError();
            case StreetTraversalPermission.ALL -> (Double)cycleSafetyHighway.apply((Float)speedLimit, (OSMWithTags)way);
            case StreetTraversalPermission.BICYCLE_AND_CAR -> cycleSafetyVeryHighTraffic;
            case StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE -> 1.12;
            case StreetTraversalPermission.BICYCLE -> 1.05;
            case StreetTraversalPermission.PEDESTRIAN_AND_CAR, StreetTraversalPermission.PEDESTRIAN, StreetTraversalPermission.CAR, StreetTraversalPermission.NONE -> cycleSafetyVeryHighTraffic;
        });
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.EqualsAnyIn("highway", "motorway", "motorway_link")), WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR));
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(isTrunkOrPrimary, new Condition.Equals("motorroad", "yes")), WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR));
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(isNormalRoad), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL));
        WayProperties cycleLaneInHighTraffic = WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.27).build();
        WayProperties cycleLaneInLowTraffic = WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1).build();
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.Equals("cycleway", "track"), isNormalRoad), WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.0).build());
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.Equals("cycleway", "lane"), isClassifiedRoad), cycleLaneInHighTraffic);
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.Equals("cycleway", "lane"), new Condition.LessThan("maxspeed", 50), isClassifiedRoad), cycleLaneInLowTraffic);
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.Equals("cycleway", "lane"), new Condition.EqualsAnyIn("highway", "unclassified", "residential")), cycleLaneInLowTraffic);
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.Equals("cycleway", "shared_lane"), isNormalRoad), MixinPropertiesBuilder.ofBicycleSafety(0.85));
        props.setMixinProperties(new LogicalOrSpecifier("lcn=yes", "rcn=yes", "ncn=yes"), MixinPropertiesBuilder.ofBicycleSafety(0.85));
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.Equals("oneway", "yes"), new Condition.EqualsAnyInOrAbsent("cycleway"), isNormalRoad), MixinPropertiesBuilder.ofBicycleSafety(1.0, 1.15));
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.EqualsAnyIn("embedded_rails", "tram", "light_rail", "disused")), MixinPropertiesBuilder.ofBicycleSafety(1.2));
        ExactMatchSpecifier exactMatchSpecifier = new ExactMatchSpecifier(new Condition.Equals("tunnel", "yes"), isClassifiedOrUnclassifiedRoad);
        MixinPropertiesBuilder.ofBicycleSafety(2.0);
        props.setMixinProperties(exactMatchSpecifier, MixinPropertiesBuilder.ofWalkSafety(2.0));
        props.setMixinProperties(new LogicalOrSpecifier(new ExactMatchSpecifier(new Condition.Equals("bridge", "yes"), new Condition.EqualsAnyInOrAbsent("sidewalk", "no", "separate"), isClassifiedOrUnclassifiedRoad), new ExactMatchSpecifier(new Condition.Equals("verge", "no"), new Condition.EqualsAnyInOrAbsent("sidewalk", "no", "separate"), isClassifiedOrUnclassifiedRoad)), MixinPropertiesBuilder.ofWalkSafety(2.0));
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.Equals("junction", "roundabout"), new Condition.EqualsAnyInOrAbsent("sidewalk", "no", "separate")), MixinPropertiesBuilder.ofWalkSafety(2.0));
        props.setProperties("highway=service", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL));
        props.setProperties("highway=service;service=parking_aisle", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(cycleSafetyMediumTraffic));
        props.setProperties("highway=service;service=drive-through", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(cycleSafetyMediumTraffic));
        props.setProperties("highway=living_street", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(cycleSafetyLowTraffic));
        props.setProperties("highway=pedestrian", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.2));
        props.setProperties("highway=busway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(cycleSafetyMediumLowTraffic).walkSafety(1.9));
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.Equals("highway", "service"), new Condition.EqualsAnyIn("bus", "yes", "designated")), WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(cycleSafetyMediumLowTraffic).walkSafety(1.9));
        WayProperties footway = WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.42).walkSafety(1.0).build();
        WayProperties cycleway = WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.05).walkSafety(1.4).build();
        WayProperties cyclewayWithSidewalk = WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.05).walkSafety(1.0).build();
        WayProperties twoLaneOrOnewayCycleway = WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.0).walkSafety(1.4).build();
        WayProperties twoLaneOrOnewayCyclewayWithSidewalk = WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.0).walkSafety(1.0).build();
        WayProperties combinedFootAndCycleway = WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.05).walkSafety(1.15).build();
        props.setProperties("highway=footway", footway);
        props.setProperties("highway=cycleway", cycleway);
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.Equals("highway", "cycleway"), new Condition.GreaterThan("lanes", 1)), twoLaneOrOnewayCycleway);
        props.setProperties("highway=cycleway;oneway=yes", twoLaneOrOnewayCycleway);
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.Equals("highway", "cycleway"), hasSidewalk), cyclewayWithSidewalk);
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.Equals("highway", "cycleway"), new Condition.GreaterThan("lanes", 1), hasSidewalk), twoLaneOrOnewayCyclewayWithSidewalk);
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.Equals("highway", "cycleway"), new Condition.Equals("oneway", "yes"), hasSidewalk), twoLaneOrOnewayCyclewayWithSidewalk);
        props.setProperties("highway=cycleway;foot=designated;segregated=no", combinedFootAndCycleway);
        props.setProperties("highway=path;foot=designated;bicycle=designated;segregated=no", combinedFootAndCycleway);
        props.setProperties("highway=cycleway;foot=designated;segregated=yes", cyclewayWithSidewalk);
        props.setProperties("highway=path;foot=designated;bicycle=designated;segregated=yes", cyclewayWithSidewalk);
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.Equals("highway", "cycleway"), new Condition.Equals("foot", "designated"), new Condition.Equals("segregated", "yes"), new Condition.GreaterThan("lanes", 1)), twoLaneOrOnewayCyclewayWithSidewalk);
        props.setProperties("highway=cycleway;foot=designated;segregated=*;motor_vehicle=destination", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(cycleSafetyVeryLowTraffic));
        props.setProperties("highway=path;foot=designated;bicycle=designated;segregated=*;motor_vehicle=destination", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(cycleSafetyVeryLowTraffic));
        props.setProperties("highway=footway;footway=sidewalk", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(1.93).walkSafety(1.1));
        props.setProperties("highway=footway;footway=crossing", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(2.33).walkSafety(1.35));
        props.setProperties("highway=cycleway;cycleway=crossing", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(2.33).walkSafety(1.35));
        props.setProperties("highway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE));
        props.setProperties("highway=bridleway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE));
        props.setProperties("highway=path", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE));
        props.setProperties("highway=steps", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN));
        props.setProperties("highway=corridor", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN));
        props.setProperties("highway=footway;indoor=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN));
        props.setProperties("highway=platform", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN));
        props.setProperties("public_transport=platform", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN));
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.EqualsAnyIn("trail_visibility", "bad", "low", "poor", "horrible", "no"), new Condition.Equals("highway", "path")), WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.EqualsAnyIn("sac_scale", "demanding_mountain_hiking", "alpine_hiking", "demanding_alpine_hiking", "difficult_alpine_hiking"), new Condition.EqualsAnyIn("highway", "path", "steps")), WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.EqualsAnyIn("smoothness", "horrible", "very_horrible"), new Condition.EqualsAnyIn("highway", "path", "bridleway", "track")), WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.15));
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.Equals("smoothness", "impassable"), new Condition.EqualsAnyIn("highway", "path", "bridleway", "track")), WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.InclusiveRange("mtb:scale", 2, 1), new Condition.EqualsAnyIn("highway", "path", "bridleway", "track")), WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.15));
        props.setProperties((OsmSpecifier)new ExactMatchSpecifier(new Condition.GreaterThan("mtb:scale", 2), new Condition.EqualsAnyIn("highway", "path", "bridleway", "track")), WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setMixinProperties("surface=grass_paver", MixinPropertiesBuilder.ofBicycleSafety(1.2));
        props.setMixinProperties("surface=sett", MixinPropertiesBuilder.ofBicycleSafety(1.2));
        props.setMixinProperties("surface=cobblestone", MixinPropertiesBuilder.ofBicycleSafety(1.2));
        props.setMixinProperties("surface=unhewn_cobblestone", MixinPropertiesBuilder.ofBicycleSafety(3.0));
        props.setMixinProperties("surface=metal_grid", MixinPropertiesBuilder.ofBicycleSafety(1.2));
        props.setMixinProperties("surface=metal", MixinPropertiesBuilder.ofBicycleSafety(1.2));
        Condition.EqualsAnyIn isPaved = new Condition.EqualsAnyIn("surface", "asfalt", "concrete", "paving_stones", "paved", "wood");
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.Equals("smoothness", "intermediate"), isPaved), MixinPropertiesBuilder.ofBicycleSafety(1.2));
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.Equals("smoothness", "bad"), isPaved), MixinPropertiesBuilder.ofBicycleSafety(1.4).walkSafety(1.6));
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.Equals("surface", "unpaved"), new Condition.Absent("tracktype")), MixinPropertiesBuilder.ofBicycleSafety(1.8).walkSafety(1.6));
        props.setMixinProperties("surface=compacted", MixinPropertiesBuilder.ofBicycleSafety(1.4).walkSafety(1.4));
        props.setMixinProperties("surface=fine_gravel", MixinPropertiesBuilder.ofBicycleSafety(1.8).walkSafety(1.6));
        props.setMixinProperties("surface=pebblestone", MixinPropertiesBuilder.ofBicycleSafety(1.8).walkSafety(1.6));
        props.setMixinProperties("surface=gravel", MixinPropertiesBuilder.ofBicycleSafety(1.8).walkSafety(1.6));
        props.setMixinProperties("surface=woodchip", MixinPropertiesBuilder.ofBicycleSafety(1.8).walkSafety(1.6));
        props.setMixinProperties("surface=ground", MixinPropertiesBuilder.ofBicycleSafety(2.3).walkSafety(2.4));
        props.setMixinProperties("surface=dirt", MixinPropertiesBuilder.ofBicycleSafety(2.3).walkSafety(2.4));
        props.setMixinProperties("surface=earth", MixinPropertiesBuilder.ofBicycleSafety(2.3).walkSafety(2.4));
        props.setMixinProperties("surface=grass", MixinPropertiesBuilder.ofBicycleSafety(2.3).walkSafety(1.8));
        props.setMixinProperties("surface=mud", MixinPropertiesBuilder.ofBicycleSafety(3.0).walkSafety(3.0));
        props.setMixinProperties("surface=sand", MixinPropertiesBuilder.ofBicycleSafety(3.0).walkSafety(1.8));
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.Absent("tracktype"), new Condition.EqualsAnyInOrAbsent("surface", "unpaved"), new Condition.EqualsAnyIn("highway", "track", "bridleway")), MixinPropertiesBuilder.ofBicycleSafety(1.8).walkSafety(1.6));
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.Equals("tracktype", "grade2"), new Condition.EqualsAnyInOrAbsent("surface", "unpaved"), new Condition.EqualsAnyIn("highway", "track", "bridleway", "service", "unclassified")), MixinPropertiesBuilder.ofBicycleSafety(1.4).walkSafety(1.4));
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.Equals("tracktype", "grade3"), new Condition.EqualsAnyInOrAbsent("surface", "unpaved"), new Condition.EqualsAnyIn("highway", "track", "bridleway", "service", "unclassified")), MixinPropertiesBuilder.ofBicycleSafety(1.8).walkSafety(1.6));
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.Equals("tracktype", "grade4"), new Condition.EqualsAnyInOrAbsent("surface", "unpaved"), new Condition.EqualsAnyIn("highway", "track", "bridleway", "service", "unclassified")), MixinPropertiesBuilder.ofBicycleSafety(2.3).walkSafety(1.8));
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.Equals("tracktype", "grade5"), new Condition.EqualsAnyInOrAbsent("surface", "unpaved"), new Condition.EqualsAnyIn("highway", "track", "bridleway", "service", "unclassified")), MixinPropertiesBuilder.ofBicycleSafety(2.3).walkSafety(2.4));
        props.setMixinProperties(new ExactMatchSpecifier(new Condition.EqualsAnyInOrAbsent("surface"), new Condition.Equals("highway", "path")), MixinPropertiesBuilder.ofBicycleSafety(2.3).walkSafety(2.4));
        props.setMixinProperties("sac_scale=mountain_hiking", MixinPropertiesBuilder.ofWalkSafety(1.8));
        props.setMixinProperties("trail_visibility=intermediate", MixinPropertiesBuilder.ofWalkSafety(1.8));
        props.setCarSpeed(new ExactMatchSpecifier(new Condition.EqualsAnyIn("highway", "motorway", "motorway_link")), 30.56f);
        props.setCarSpeed(new ExactMatchSpecifier(new Condition.Equals("motorroad", "yes"), isTrunkOrPrimary), 25.0f);
        props.setCarSpeed(new ExactMatchSpecifier(new Condition.EqualsAnyIn("highway", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "road", "busway")), 22.22f);
        props.setCarSpeed(new ExactMatchSpecifier(new Condition.EqualsAnyIn("sidewalk", "yes", "both", "left", "right", "separate"), new Condition.EqualsAnyIn("highway", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "road", "busway")), 13.89f);
        props.setCarSpeed("highway=residential", 13.89f);
        props.setCarSpeed("highway=service", 13.89f);
        props.setCarSpeed("highway=service;service=driveway", 8.33f);
        props.setCarSpeed("highway=service;service=parking_aisle", 8.33f);
        props.setCarSpeed("highway=track", 8.33f);
        props.setCarSpeed("highway=living_street", 1.94f);
        props.setCarSpeed("highway=pedestrian", 1.94f);
        props.defaultSpeed = Float.valueOf(22.22f);
        new DefaultMapper().populateNotesAndNames(props);
        props.setSlopeOverride(new BestMatchSpecifier("bridge=*"), true);
        props.setSlopeOverride(new BestMatchSpecifier("cutting=*"), true);
        props.setSlopeOverride(new BestMatchSpecifier("tunnel=*"), true);
        props.setSlopeOverride(new BestMatchSpecifier("location=underground"), true);
        props.setSlopeOverride(new BestMatchSpecifier("indoor=yes"), true);
    }
}

