/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.model;

import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

public class OSMWay
extends OSMWithTags {
    private final TLongList nodes = new TLongArrayList();

    public void addNodeRef(long nodeRef) {
        this.nodes.add(nodeRef);
    }

    public void addNodeRef(long nodeRef, int index) {
        this.nodes.insert(index, nodeRef);
    }

    public TLongList getNodeRefs() {
        return this.nodes;
    }

    @Override
    public String toString() {
        return "osm way " + this.id;
    }

    public boolean isClosed() {
        int size = this.nodes.size();
        if (size > 2) {
            long b;
            long a = this.nodes.get(0);
            return a == (b = this.nodes.get(size - 1));
        }
        return false;
    }

    public boolean isBoardingArea() {
        return this.isBoardingLocation() && this.isClosed();
    }

    public boolean isBicycleDismountForced() {
        String bicycle = this.getTag("bicycle");
        return this.isTag("cycleway", "dismount") != false || "dismount".equals(bicycle);
    }

    public boolean isSteps() {
        return "steps".equals(this.getTag("highway"));
    }

    public boolean isRoundabout() {
        return "roundabout".equals(this.getTag("junction"));
    }

    public boolean isOneWayForwardDriving() {
        return this.isTagTrue("oneway");
    }

    public boolean isOneWayReverseDriving() {
        return this.isTag("oneway", "-1");
    }

    public boolean isOneWayForwardBicycle() {
        String oneWayBicycle = this.getTag("oneway:bicycle");
        return OSMWay.isTrue(oneWayBicycle) || this.isTagFalse("bicycle:backwards");
    }

    public boolean isOneWayReverseBicycle() {
        String oneWayBicycle = this.getTag("oneway:bicycle");
        return "-1".equals(oneWayBicycle) || this.isTagFalse("bicycle:forward");
    }

    public boolean isForwardDirectionSidepath() {
        return "use_sidepath".equals(this.getTag("bicycle:forward"));
    }

    public boolean isReverseDirectionSidepath() {
        return "use_sidepath".equals(this.getTag("bicycle:backward"));
    }

    public boolean isOpposableCycleway() {
        String cycleway = this.getTag("cycleway");
        String cyclewayLeft = this.getTag("cycleway:left");
        String cyclewayRight = this.getTag("cycleway:right");
        return cycleway != null && cycleway.startsWith("opposite") || cyclewayLeft != null && cyclewayLeft.startsWith("opposite") || cyclewayRight != null && cyclewayRight.startsWith("opposite");
    }

    @Override
    public String getOpenStreetMapLink() {
        return String.format("https://www.openstreetmap.org/way/%d", this.getId());
    }
}

