/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.openstreetmap.issues.FloorNumberUnknownAssumedGroundLevel;
import org.opentripplanner.openstreetmap.issues.FloorNumberUnknownGuessedFromAltitude;

public class OSMLevel
implements Comparable<OSMLevel> {
    public static final Pattern RANGE_PATTERN = Pattern.compile("^[0-9]+-[0-9]+$");
    public static final double METERS_PER_FLOOR = 3.0;
    public static final OSMLevel DEFAULT = new OSMLevel(0, 0.0, "default level", "default level", Source.NONE, true);
    public final int floorNumber;
    public final double altitudeMeters;
    public final String shortName;
    public final String longName;
    public final Source source;
    public final boolean reliable;

    public OSMLevel(int floorNumber, double altitudeMeters, String shortName, String longName, Source source, boolean reliable) {
        this.floorNumber = floorNumber;
        this.altitudeMeters = altitudeMeters;
        this.shortName = shortName;
        this.longName = longName;
        this.source = source;
        this.reliable = reliable;
    }

    public static OSMLevel fromString(String spec, Source source, boolean incrementNonNegative, DataImportIssueStore issueStore) {
        Double altitude = null;
        boolean reliable = true;
        int lastIndexAt = spec.lastIndexOf(64);
        if (lastIndexAt != -1) {
            try {
                altitude = Double.parseDouble(spec.substring(lastIndexAt + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            spec = spec.substring(0, lastIndexAt);
        }
        String shortName = "";
        String longName = "";
        Integer indexEquals = spec.indexOf(61);
        if (indexEquals >= 1) {
            shortName = spec.substring(0, indexEquals);
            longName = spec.substring(indexEquals + 1);
        } else {
            shortName = longName = spec;
        }
        if (longName.startsWith("+")) {
            longName = longName.substring(1);
        }
        if (shortName.startsWith("+")) {
            shortName = shortName.substring(1);
        }
        Integer floorNumber = null;
        try {
            floorNumber = Integer.parseInt(longName);
            if (incrementNonNegative) {
                if (source == Source.LEVEL_MAP) {
                    if (floorNumber >= 1) {
                        floorNumber = floorNumber - 1;
                    }
                } else if (floorNumber >= 0) {
                    longName = Integer.toString(floorNumber + 1);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            floorNumber = Integer.parseInt(shortName);
            if (incrementNonNegative) {
                if (source == Source.LEVEL_MAP) {
                    if (floorNumber >= 1) {
                        floorNumber = floorNumber - 1;
                    }
                } else if (floorNumber >= 0) {
                    shortName = Integer.toString(floorNumber + 1);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (floorNumber == null && altitude != null) {
            floorNumber = (int)(altitude / 3.0);
            issueStore.add(new FloorNumberUnknownGuessedFromAltitude(spec, floorNumber));
            reliable = false;
        }
        if (altitude == null) {
            altitude = 0.0;
        }
        if (floorNumber == null) {
            floorNumber = 0;
            issueStore.add(new FloorNumberUnknownAssumedGroundLevel(spec, floorNumber));
            reliable = false;
        }
        return new OSMLevel(floorNumber, altitude, shortName, longName, source, reliable);
    }

    public static List<OSMLevel> fromSpecList(String specList, Source source, boolean incrementNonNegative, DataImportIssueStore issueStore) {
        ArrayList<String> levelSpecs = new ArrayList<String>();
        for (String level : specList.split(";")) {
            Matcher m = RANGE_PATTERN.matcher(level);
            if (m.matches()) {
                String[] range = level.split("-");
                int endOfRange = Integer.parseInt(range[1]);
                for (int i = Integer.parseInt(range[0]); i <= endOfRange; ++i) {
                    levelSpecs.add(Integer.toString(i));
                }
                continue;
            }
            levelSpecs.add(level);
        }
        ArrayList<OSMLevel> levels = new ArrayList<OSMLevel>();
        for (String spec : levelSpecs) {
            levels.add(OSMLevel.fromString(spec, source, incrementNonNegative, issueStore));
        }
        return levels;
    }

    public static Map<String, OSMLevel> mapFromSpecList(String specList, Source source, boolean incrementNonNegative, DataImportIssueStore issueStore) {
        HashMap<String, OSMLevel> map = new HashMap<String, OSMLevel>();
        for (OSMLevel level : OSMLevel.fromSpecList(specList, source, incrementNonNegative, issueStore)) {
            map.put(level.shortName, level);
        }
        return map;
    }

    @Override
    public int compareTo(OSMLevel other) {
        return this.floorNumber - other.floorNumber;
    }

    public int hashCode() {
        return this.floorNumber;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof OSMLevel)) {
            return false;
        }
        return this.floorNumber == ((OSMLevel)other).floorNumber;
    }

    public static enum Source {
        LEVEL_MAP,
        LEVEL_TAG,
        LAYER_TAG,
        ALTITUDE,
        NONE;

    }
}

