/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.validation;

import javax.annotation.Nullable;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.netex.index.api.HMapValidationRule;
import org.opentripplanner.netex.issues.ObjectNotFound;
import org.opentripplanner.netex.validation.AbstractHMapValidationRule;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.OperatingDay;
import org.rutebanken.netex.model.OperatingDayRefStructure;

class DSJOperatingDayNotFound
extends AbstractHMapValidationRule<String, DatedServiceJourney> {
    DSJOperatingDayNotFound() {
    }

    @Override
    public HMapValidationRule.Status validate(DatedServiceJourney dsj) {
        String ref = this.getOperatingDayRef(dsj);
        OperatingDay opDay = (OperatingDay)this.index.getOperatingDayById().lookup(ref);
        return opDay == null ? HMapValidationRule.Status.DISCARD : HMapValidationRule.Status.OK;
    }

    @Override
    public DataImportIssue logMessage(String dsjId, DatedServiceJourney dsj) {
        String ref = this.getOperatingDayRef(dsj);
        return new ObjectNotFound("DatedServiceJourney", dsj.getId(), "OperatingDayRef", ref);
    }

    @Nullable
    private String getOperatingDayRef(DatedServiceJourney dsj) {
        OperatingDayRefStructure ref = dsj.getOperatingDayRef();
        return ref == null ? null : ref.getRef();
    }
}

