/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping.support;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.xml.bind.JAXBElement;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.netex.index.api.NetexEntityIndexReadOnlyView;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.transit.model.site.Station;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.JourneyRefStructure;

public class NetexMapperIndexes {
    private final Multimap<String, Station> stationsByMultiModalStationRfs;
    private final Map<String, StopTime> stopTimesByNetexId;
    private final Multimap<String, DatedServiceJourney> datedServiceJourneysBySjId;
    private NetexMapperIndexes parent;

    public NetexMapperIndexes(NetexEntityIndexReadOnlyView index, NetexMapperIndexes parent) {
        this.parent = parent;
        if (parent == null) {
            this.datedServiceJourneysBySjId = NetexMapperIndexes.indexDSJBySJId(index.getDatedServiceJourneys());
            this.stationsByMultiModalStationRfs = ArrayListMultimap.create();
            this.stopTimesByNetexId = new HashMap<String, StopTime>();
        } else {
            this.datedServiceJourneysBySjId = index.getDatedServiceJourneys().localKeys().isEmpty() ? parent.datedServiceJourneysBySjId : NetexMapperIndexes.indexDSJBySJId(index.getDatedServiceJourneys());
            this.stationsByMultiModalStationRfs = parent.stationsByMultiModalStationRfs;
            this.stopTimesByNetexId = parent.stopTimesByNetexId;
        }
    }

    public NetexMapperIndexes getParent() {
        return this.parent;
    }

    public Multimap<String, Station> getStationsByMultiModalStationRfs() {
        return this.stationsByMultiModalStationRfs;
    }

    public void addStationByMultiModalStationRfs(Multimap<String, Station> stationByMultiModalStationRfs) {
        this.stationsByMultiModalStationRfs.putAll(stationByMultiModalStationRfs);
    }

    public Map<String, StopTime> getStopTimesByNetexId() {
        return this.stopTimesByNetexId;
    }

    public void addStopTimesByNetexId(Map<String, StopTime> stopTimesByNetexId) {
        this.stopTimesByNetexId.putAll(stopTimesByNetexId);
    }

    public Multimap<String, DatedServiceJourney> getDatedServiceJourneysBySjId() {
        return this.datedServiceJourneysBySjId;
    }

    static Multimap<String, DatedServiceJourney> indexDSJBySJId(ReadOnlyHierarchicalMapById<DatedServiceJourney> datedServiceJourneys) {
        ArrayListMultimap dsjBySJId = ArrayListMultimap.create();
        for (DatedServiceJourney dsj : datedServiceJourneys.localValues()) {
            String sjId = ((JourneyRefStructure)((JAXBElement)dsj.getJourneyRef().get(0)).getValue()).getRef();
            dsjBySJId.put((Object)sjId, (Object)dsj);
        }
        return dsjBySJId;
    }
}

