/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.i18n.TranslatedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.netex.mapping.StopTransferPriorityMapper;
import org.opentripplanner.netex.mapping.WgsCoordinateMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StationBuilder;
import org.rutebanken.netex.model.AlternativeName;
import org.rutebanken.netex.model.LimitedUseTypeEnumeration;
import org.rutebanken.netex.model.LocaleStructure;
import org.rutebanken.netex.model.MultilingualString;
import org.rutebanken.netex.model.NameTypeEnumeration;
import org.rutebanken.netex.model.Quay;
import org.rutebanken.netex.model.StopPlace;

class StationMapper {
    private final DataImportIssueStore issueStore;
    private final FeedScopedIdFactory idFactory;
    private final ZoneId defaultTimeZone;
    private final boolean noTransfersOnIsolatedStops;
    private final EntityById<Station> stationsById;

    StationMapper(DataImportIssueStore issueStore, FeedScopedIdFactory idFactory, ZoneId defaultTimeZone, boolean noTransfersOnIsolatedStops, EntityById<Station> stationsById) {
        this.issueStore = issueStore;
        this.idFactory = idFactory;
        this.defaultTimeZone = defaultTimeZone;
        this.noTransfersOnIsolatedStops = noTransfersOnIsolatedStops;
        this.stationsById = stationsById;
    }

    Station map(StopPlace stopPlace) {
        return this.stationsById.computeIfAbsent(this.idFactory.createId(stopPlace.getId()), ignored -> this.mapStopPlaceToStation(stopPlace));
    }

    Station mapStopPlaceToStation(StopPlace stopPlace) {
        StationBuilder builder = Station.of(this.idFactory.createId(stopPlace.getId())).withName(this.resolveName(stopPlace)).withCoordinate(this.mapCoordinate(stopPlace)).withDescription(NonLocalizedString.ofNullable(stopPlace.getDescription(), MultilingualString::getValue)).withPriority(StopTransferPriorityMapper.mapToDomain(stopPlace.getWeighting())).withTimezone(Optional.ofNullable(stopPlace.getLocale()).map(LocaleStructure::getTimeZone).map((? super T zoneId) -> this.ofZoneId(stopPlace.getId(), (String)zoneId)).orElse(this.defaultTimeZone));
        if (this.noTransfersOnIsolatedStops) {
            builder.withTransfersNotAllowed(LimitedUseTypeEnumeration.ISOLATED.equals((Object)stopPlace.getLimitedUse()));
        }
        return (Station)builder.build();
    }

    private ZoneId ofZoneId(String stopPlaceId, String zoneId) {
        try {
            return ZoneId.of(zoneId);
        }
        catch (DateTimeException e) {
            this.issueStore.add("InvalidTimeZone", "Invalid ID for ZoneOffset at StopPlace with ID: %s and value %s", stopPlaceId, zoneId);
            return null;
        }
    }

    private I18NString resolveName(StopPlace stopPlace) {
        I18NString name;
        if (stopPlace.getName() == null) {
            name = new NonLocalizedString("N/A");
        } else if (stopPlace.getAlternativeNames() != null) {
            HashMap<String, String> translations = new HashMap<String, String>();
            translations.put(null, stopPlace.getName().getValue());
            for (AlternativeName translation : stopPlace.getAlternativeNames().getAlternativeName()) {
                if (translation.getNameType() != NameTypeEnumeration.TRANSLATION) continue;
                String lang = translation.getLang() != null ? translation.getLang() : translation.getName().getLang();
                translations.put(lang, translation.getName().getValue());
            }
            name = TranslatedString.getI18NString(translations, true, false);
        } else {
            name = new NonLocalizedString(stopPlace.getName().getValue());
        }
        return name;
    }

    private WgsCoordinate mapCoordinate(StopPlace stopPlace) {
        if (stopPlace.getCentroid() != null) {
            return WgsCoordinateMapper.mapToDomain(stopPlace.getCentroid());
        }
        this.issueStore.add("StationWithoutCoordinates", "Station %s does not contain any coordinates.", stopPlace.getId() + " " + stopPlace.getName());
        ArrayList<WgsCoordinate> coordinates = new ArrayList<WgsCoordinate>();
        for (Object it : stopPlace.getQuays().getQuayRefOrQuay()) {
            Quay quay;
            if (!(it instanceof Quay) || (quay = (Quay)it).getCentroid() == null) continue;
            coordinates.add(WgsCoordinateMapper.mapToDomain(quay.getCentroid()));
        }
        if (coordinates.isEmpty()) {
            throw new IllegalArgumentException("Station w/quays without coordinates. Station id: " + stopPlace.getId());
        }
        return WgsCoordinate.mean(coordinates);
    }
}

