/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.framework.lang.StringUtils;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.organization.OperatorBuilder;
import org.rutebanken.netex.model.ContactStructure;

class OperatorToAgencyMapper {
    private DataImportIssueStore issueStore;
    private final FeedScopedIdFactory idFactory;

    OperatorToAgencyMapper(DataImportIssueStore issueStore, FeedScopedIdFactory idFactory) {
        this.issueStore = issueStore;
        this.idFactory = idFactory;
    }

    Operator mapOperator(org.rutebanken.netex.model.Operator source) {
        String name;
        if (source.getName() == null || !StringUtils.hasValue(source.getName().getValue())) {
            this.issueStore.add("MissingOperatorName", "Missing name for operator %s", source.getId());
            name = source.getId();
        } else {
            name = source.getName().getValue();
        }
        OperatorBuilder target = Operator.of(this.idFactory.createId(source.getId())).withName(name);
        OperatorToAgencyMapper.mapContactDetails(source.getContactDetails(), target);
        return (Operator)target.build();
    }

    private static void mapContactDetails(ContactStructure contactDetails, OperatorBuilder target) {
        if (contactDetails == null) {
            return;
        }
        target.withUrl(contactDetails.getUrl());
        target.withPhone(contactDetails.getPhone());
    }
}

