/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import com.google.common.collect.Multimap;
import jakarta.xml.bind.JAXBElement;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.calendar.ServiceCalendar;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.netex.index.api.NetexEntityIndexReadOnlyView;
import org.opentripplanner.netex.mapping.AuthorityToAgencyMapper;
import org.opentripplanner.netex.mapping.BrandingMapper;
import org.opentripplanner.netex.mapping.FlexStopsMapper;
import org.opentripplanner.netex.mapping.GroupNetexMapper;
import org.opentripplanner.netex.mapping.GroupOfRoutesMapper;
import org.opentripplanner.netex.mapping.GroupOfStationsMapper;
import org.opentripplanner.netex.mapping.MultiModalStationMapper;
import org.opentripplanner.netex.mapping.NoticeAssignmentMapper;
import org.opentripplanner.netex.mapping.OperatorToAgencyMapper;
import org.opentripplanner.netex.mapping.RouteMapper;
import org.opentripplanner.netex.mapping.StopAndStationMapper;
import org.opentripplanner.netex.mapping.TariffZoneMapper;
import org.opentripplanner.netex.mapping.TripCalendarBuilder;
import org.opentripplanner.netex.mapping.TripPatternMapper;
import org.opentripplanner.netex.mapping.TripPatternMapperResult;
import org.opentripplanner.netex.mapping.calendar.CalendarServiceBuilder;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.netex.mapping.support.NetexMapperIndexes;
import org.opentripplanner.transit.model.basic.Notice;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.rutebanken.netex.model.Authority;
import org.rutebanken.netex.model.Branding;
import org.rutebanken.netex.model.FlexibleStopPlace;
import org.rutebanken.netex.model.GroupOfLines;
import org.rutebanken.netex.model.GroupOfStopPlaces;
import org.rutebanken.netex.model.JourneyPattern_VersionStructure;
import org.rutebanken.netex.model.Line;
import org.rutebanken.netex.model.LineRefs_RelStructure;
import org.rutebanken.netex.model.Line_VersionStructure;
import org.rutebanken.netex.model.NoticeAssignment;
import org.rutebanken.netex.model.Operator;
import org.rutebanken.netex.model.StopPlace;
import org.rutebanken.netex.model.VersionOfObjectRefStructure;

public class NetexMapper {
    private static final int LEVEL_SHARED = 0;
    private static final int LEVEL_GROUP = 1;
    private final FeedScopedIdFactory idFactory;
    private final OtpTransitServiceBuilder transitBuilder;
    private final Deduplicator deduplicator;
    private final DataImportIssueStore issueStore;
    private final CalendarServiceBuilder calendarServiceBuilder;
    private final TripCalendarBuilder tripCalendarBuilder;
    private final Set<String> ferryIdsNotAllowedForBicycle;
    private final double maxStopToShapeSnapDistance;
    private final boolean noTransfersOnIsolatedStops;
    private GroupNetexMapper groupMapper;
    private NetexEntityIndexReadOnlyView currentNetexIndex;
    private NetexMapperIndexes currentMapperIndexes = null;
    private int level = 0;

    public NetexMapper(OtpTransitServiceBuilder transitBuilder, String feedId, Deduplicator deduplicator, DataImportIssueStore issueStore, Set<String> ferryIdsNotAllowedForBicycle, double maxStopToShapeSnapDistance, boolean noTransfersOnIsolatedStops) {
        this.transitBuilder = transitBuilder;
        this.deduplicator = deduplicator;
        this.idFactory = new FeedScopedIdFactory(feedId);
        this.issueStore = issueStore;
        this.ferryIdsNotAllowedForBicycle = ferryIdsNotAllowedForBicycle;
        this.noTransfersOnIsolatedStops = noTransfersOnIsolatedStops;
        this.maxStopToShapeSnapDistance = maxStopToShapeSnapDistance;
        this.calendarServiceBuilder = new CalendarServiceBuilder(this.idFactory);
        this.tripCalendarBuilder = new TripCalendarBuilder(this.calendarServiceBuilder, issueStore);
    }

    public NetexMapper push() {
        ++this.level;
        this.tripCalendarBuilder.push();
        this.setupGroupMapping();
        return this;
    }

    public NetexMapper pop() {
        this.performGroupMapping();
        this.tripCalendarBuilder.pop();
        this.currentMapperIndexes = this.currentMapperIndexes.getParent();
        --this.level;
        return this;
    }

    public void finishUp() {
        this.transitBuilder.getCalendarDates().addAll(this.calendarServiceBuilder.createServiceCalendar());
        ServiceCalendar emptyCalendar = this.calendarServiceBuilder.createEmptyCalendar();
        if (this.transitBuilder.getTripsById().values().stream().anyMatch(trip -> emptyCalendar.getServiceId().equals(trip.getServiceId()))) {
            this.transitBuilder.getCalendars().add(emptyCalendar);
        }
    }

    public void mapNetexToOtp(NetexEntityIndexReadOnlyView netexIndex) {
        this.currentNetexIndex = netexIndex;
        this.currentMapperIndexes = new NetexMapperIndexes(netexIndex, this.currentMapperIndexes);
        this.mapAuthorities();
        this.mapOperators();
        this.mapBrandings();
        TariffZoneMapper tariffZoneMapper = this.mapTariffZones();
        this.mapStopPlaceAndQuays(tariffZoneMapper);
        this.mapMultiModalStopPlaces();
        this.mapGroupsOfStopPlaces();
        this.mapFlexibleStopPlaces();
        this.addDatedServiceJourneysToTripCalendar();
        this.mapDayTypeAssignments();
        Map<String, FeedScopedId> serviceIds = this.createCalendarForServiceJourney();
        this.mapRoute();
        this.mapGroupsOfLines();
        this.mapTripPatterns(serviceIds);
        this.mapNoticeAssignments();
        this.addEntriesToGroupMapperForPostProcessingLater();
    }

    private void setupGroupMapping() {
        if (this.level != 1) {
            return;
        }
        this.groupMapper = new GroupNetexMapper(this.idFactory, this.issueStore, this.transitBuilder);
    }

    private void performGroupMapping() {
        if (this.level != 1) {
            return;
        }
        this.groupMapper.mapGroupEntries();
        this.groupMapper = null;
    }

    private void mapAuthorities() {
        AuthorityToAgencyMapper agencyMapper = new AuthorityToAgencyMapper(this.idFactory, this.currentNetexIndex.getTimeZone());
        for (Authority authority : this.currentNetexIndex.getAuthoritiesById().localValues()) {
            Agency agency = agencyMapper.mapAuthorityToAgency(authority);
            this.transitBuilder.getAgenciesById().add(agency);
        }
    }

    private void mapBrandings() {
        BrandingMapper mapper = new BrandingMapper(this.idFactory);
        for (Branding branding : this.currentNetexIndex.getBrandingById().localValues()) {
            this.transitBuilder.getBrandingsById().add(mapper.mapBranding(branding));
        }
    }

    private void mapGroupsOfLines() {
        GroupOfRoutesMapper mapper = new GroupOfRoutesMapper(this.idFactory);
        this.currentNetexIndex.getGroupsOfLinesById().localValues().forEach(gol -> {
            GroupOfRoutes model = mapper.mapGroupOfRoutes((GroupOfLines)gol);
            Optional.ofNullable(gol.getMembers()).stream().map(LineRefs_RelStructure::getLineRef).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(JAXBElement::getValue).filter(Objects::nonNull).map(VersionOfObjectRefStructure::getRef).filter(Objects::nonNull).forEach(ref -> {
                FeedScopedId routeId = this.idFactory.createId((String)ref);
                this.transitBuilder.getGroupsOfRoutesByRouteId().put((Object)routeId, (Object)model);
            });
            this.transitBuilder.getGroupOfRouteById().add(model);
        });
    }

    private void mapOperators() {
        OperatorToAgencyMapper mapper = new OperatorToAgencyMapper(this.issueStore, this.idFactory);
        for (Operator operator : this.currentNetexIndex.getOperatorsById().localValues()) {
            this.transitBuilder.getOperatorsById().add(mapper.mapOperator(operator));
        }
    }

    private TariffZoneMapper mapTariffZones() {
        TariffZoneMapper tariffZoneMapper = new TariffZoneMapper(this.getStartOfPeriod(), this.idFactory, this.currentNetexIndex.getTariffZonesById());
        this.transitBuilder.getFareZonesById().addAll(tariffZoneMapper.listAllCurrentFareZones());
        return tariffZoneMapper;
    }

    private void mapStopPlaceAndQuays(TariffZoneMapper tariffZoneMapper) {
        String timeZone = this.currentNetexIndex.getTimeZone();
        ZoneId zoneId = timeZone != null ? ZoneId.of(timeZone) : null;
        StopAndStationMapper stopMapper = new StopAndStationMapper(this.idFactory, this.currentNetexIndex.getQuayById(), tariffZoneMapper, this.transitBuilder.stopModelBuilder(), zoneId, this.issueStore, this.noTransfersOnIsolatedStops);
        for (String stopPlaceId : this.currentNetexIndex.getStopPlaceById().localKeys()) {
            Collection<StopPlace> stopPlaceAllVersions = this.currentNetexIndex.getStopPlaceById().lookup(stopPlaceId);
            stopMapper.mapParentAndChildStops(stopPlaceAllVersions);
        }
        this.transitBuilder.getStops().addAll(stopMapper.resultStops);
        this.transitBuilder.getStations().addAll(stopMapper.resultStations);
        this.currentMapperIndexes.addStationByMultiModalStationRfs(stopMapper.resultStationByMultiModalStationRfs);
    }

    private void mapMultiModalStopPlaces() {
        MultiModalStationMapper mapper = new MultiModalStationMapper(this.issueStore, this.idFactory);
        for (StopPlace multiModalStopPlace : this.currentNetexIndex.getMultiModalStopPlaceById().localValues()) {
            Collection stations = this.currentMapperIndexes.getStationsByMultiModalStationRfs().get((Object)multiModalStopPlace.getId());
            MultiModalStation multiModalStation = mapper.map(multiModalStopPlace, stations);
            this.transitBuilder.getMultiModalStationsById().add(multiModalStation);
        }
    }

    private void mapGroupsOfStopPlaces() {
        GroupOfStationsMapper groupOfStationsMapper = new GroupOfStationsMapper(this.issueStore, this.idFactory, this.transitBuilder.getMultiModalStationsById(), this.transitBuilder.getStations());
        for (GroupOfStopPlaces groupOfStopPlaces : this.currentNetexIndex.getGroupOfStopPlacesById().localValues()) {
            this.transitBuilder.getGroupsOfStationsById().add(groupOfStationsMapper.map(groupOfStopPlaces));
        }
    }

    private void mapFlexibleStopPlaces() {
        Collection flexibleStopPlaces = this.currentNetexIndex.getFlexibleStopPlacesById().localValues();
        if (flexibleStopPlaces.size() == 0) {
            return;
        }
        FlexStopsMapper flexStopsMapper = new FlexStopsMapper(this.idFactory, this.transitBuilder.getStops().values(), this.issueStore);
        for (FlexibleStopPlace flexibleStopPlace : flexibleStopPlaces) {
            StopLocation stopLocation = flexStopsMapper.map(flexibleStopPlace);
            if (stopLocation instanceof AreaStop) {
                this.transitBuilder.getAreaStops().add((AreaStop)stopLocation);
                continue;
            }
            if (!(stopLocation instanceof GroupStop)) continue;
            GroupStop groupStop = (GroupStop)stopLocation;
            this.transitBuilder.getGroupStops().add(groupStop);
        }
    }

    private void addDatedServiceJourneysToTripCalendar() {
        this.tripCalendarBuilder.addDatedServiceJourneys(this.currentNetexIndex.getOperatingDayById(), this.currentMapperIndexes.getDatedServiceJourneysBySjId());
    }

    private void mapDayTypeAssignments() {
        this.tripCalendarBuilder.addDayTypeAssignments(this.currentNetexIndex.getDayTypeById(), this.currentNetexIndex.getDayTypeAssignmentByDayTypeId(), this.currentNetexIndex.getOperatingDayById(), this.currentNetexIndex.getOperatingPeriodById());
    }

    private Map<String, FeedScopedId> createCalendarForServiceJourney() {
        return this.tripCalendarBuilder.createTripCalendar(this.currentNetexIndex.getServiceJourneyById().localValues());
    }

    private void mapRoute() {
        Route route;
        RouteMapper routeMapper = new RouteMapper(this.issueStore, this.idFactory, this.transitBuilder.getAgenciesById(), this.transitBuilder.getOperatorsById(), this.transitBuilder.getBrandingsById(), this.transitBuilder.getGroupsOfRoutesByRouteId(), this.transitBuilder.getGroupOfRouteById(), this.currentNetexIndex, this.currentNetexIndex.getTimeZone(), this.ferryIdsNotAllowedForBicycle);
        for (Line line : this.currentNetexIndex.getLineById().localValues()) {
            route = routeMapper.mapRoute((Line_VersionStructure)line);
            if (route == null) continue;
            this.transitBuilder.getRoutes().add(route);
        }
        for (Line line : this.currentNetexIndex.getFlexibleLineById().localValues()) {
            route = routeMapper.mapRoute((Line_VersionStructure)line);
            if (route == null) continue;
            this.transitBuilder.getRoutes().add(route);
        }
    }

    private void mapTripPatterns(Map<String, FeedScopedId> serviceIds) {
        TripPatternMapper tripPatternMapper = new TripPatternMapper(this.issueStore, this.idFactory, this.transitBuilder.getOperatorsById(), this.transitBuilder.getStops(), this.transitBuilder.getAreaStops(), this.transitBuilder.getGroupStops(), this.transitBuilder.getRoutes(), this.currentNetexIndex.getRouteById(), this.currentNetexIndex.getJourneyPatternsById(), this.currentNetexIndex.getQuayIdByStopPointRef(), this.currentNetexIndex.getFlexibleStopPlaceByStopPointRef(), this.currentNetexIndex.getDestinationDisplayById(), this.currentNetexIndex.getServiceJourneyById(), this.currentNetexIndex.getServiceLinkById(), this.currentNetexIndex.getFlexibleLineById(), this.currentNetexIndex.getOperatingDayById(), this.currentNetexIndex.getDatedServiceJourneys(), this.currentMapperIndexes.getDatedServiceJourneysBySjId(), serviceIds, this.deduplicator, this.maxStopToShapeSnapDistance);
        for (JourneyPattern_VersionStructure journeyPattern : this.currentNetexIndex.getJourneyPatternsById().localValues()) {
            TripPatternMapperResult result = tripPatternMapper.mapTripPattern(journeyPattern);
            for (Map.Entry<Trip, List<StopTime>> it : result.tripStopTimes.entrySet()) {
                this.transitBuilder.getStopTimesSortedByTrip().put(it.getKey(), (Collection<StopTime>)it.getValue());
                this.transitBuilder.getTripsById().add(it.getKey());
            }
            for (Map.Entry<Trip, List<StopTime>> it : result.tripPatterns.entries()) {
                this.transitBuilder.getTripPatterns().put((Object)((StopPattern)((Object)it.getKey())), (Object)((TripPattern)((Object)it.getValue())));
            }
            this.currentMapperIndexes.addStopTimesByNetexId(result.stopTimeByNetexId);
            this.groupMapper.scheduledStopPointsIndex.putAll(result.scheduledStopPointsIndex);
            this.transitBuilder.getTripOnServiceDates().addAll(result.tripOnServiceDates);
        }
    }

    private void mapNoticeAssignments() {
        NoticeAssignmentMapper noticeAssignmentMapper = new NoticeAssignmentMapper(this.issueStore, this.idFactory, this.currentNetexIndex.getServiceJourneyById().localValues(), this.currentNetexIndex.getNoticeById(), this.transitBuilder.getRoutes(), this.transitBuilder.getTripsById(), this.currentMapperIndexes.getStopTimesByNetexId());
        for (NoticeAssignment noticeAssignment : this.currentNetexIndex.getNoticeAssignmentById().localValues()) {
            Multimap<AbstractTransitEntity, Notice> noticesByElementId = noticeAssignmentMapper.map(noticeAssignment);
            this.transitBuilder.getNoticeAssignments().putAll(noticesByElementId);
        }
    }

    private void addEntriesToGroupMapperForPostProcessingLater() {
        if (this.level != 0) {
            this.groupMapper.addInterchange(this.currentNetexIndex.getServiceJourneyInterchangeById().localValues());
        }
    }

    private LocalDateTime getStartOfPeriod() {
        String timeZone = this.currentNetexIndex.getTimeZone();
        if (timeZone == null) {
            LocalDateTime time = LocalDateTime.now(ZoneId.of("UTC"));
            this.issueStore.add("NetexImportTimeZone", "No timezone set for the current NeTEx input data file. The import start-of-period is set to " + time + " UTC, used to check entity validity periods.");
            return time;
        }
        return LocalDateTime.now(ZoneId.of(timeZone));
    }
}

