/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.loader.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.netex.index.NetexEntityIndex;
import org.opentripplanner.netex.loader.parser.NetexParser;
import org.rutebanken.netex.model.FareFrame_VersionFrameStructure;
import org.rutebanken.netex.model.FareZone;
import org.rutebanken.netex.model.TariffZone_VersionStructure;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FareFrameParser
extends NetexParser<FareFrame_VersionFrameStructure> {
    private static final Logger LOG = LoggerFactory.getLogger(FareFrameParser.class);
    private final Collection<TariffZone_VersionStructure> fareZones = new ArrayList<TariffZone_VersionStructure>();

    @Override
    void parse(FareFrame_VersionFrameStructure frame) {
        if (frame.getFareZones() != null) {
            this.parseFareZones(frame.getFareZones().getFareZone());
        }
        FareFrameParser.warnOnMissingMapping(LOG, frame.getAccessRightParameterAssignments());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getBorderPoints());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getControllableElements());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getDistanceMatrixElements());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getDistributionAssignments());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getDistributionChannels());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getFareProducts());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getFareScheduledStopPoints());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getFareSections());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getFareStructureElements());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getFareTables());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getFulfilmentMethods());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getGeographicalIntervals());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getGeographicalStructureFactors());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getGeographicalUnits());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getGroupOfDistributionAssignments());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getGroupsOfDistanceMatrixElements());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getGroupsOfDistributionChannels());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getGroupsOfSalesOfferPackages());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getMode());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getNoticeAssignments());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getNotices());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getParkingTariffs());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getPriceGroups());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getPricingParameterSet());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getQualityStructureFactors());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getSalesOfferPackageElements());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getSalesOfferPackages());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getSalesOfferPackageSubstitutions());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getSeriesConstraints());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getTariffs());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getTimeIntervals());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getTimeStructureFactors());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getTimeUnits());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getTransportOrganisationRef());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getTypesOfTravelDocuments());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getUsageParameters());
        FareFrameParser.warnOnMissingMapping(LOG, frame.getValidableElements());
        FareFrameParser.verifyCommonUnusedPropertiesIsNotSet(LOG, (VersionFrame_VersionStructure)frame);
    }

    @Override
    void setResultOnIndex(NetexEntityIndex netexIndex) {
        netexIndex.tariffZonesById.addAll(this.fareZones);
    }

    private void parseFareZones(List<FareZone> fareZone) {
        this.fareZones.addAll(fareZone);
    }
}

