/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex;

import java.util.List;
import org.opentripplanner.ext.flex.FlexTripsMapper;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.AddTransitModelEntitiesToGraph;
import org.opentripplanner.graph_builder.module.ValidateAndInterpolateStopTimesForEachTrip;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.netex.NetexBundle;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.service.TransitModel;

public class NetexModule
implements GraphBuilderModule {
    private final int subwayAccessTime;
    private final Graph graph;
    private final TransitModel transitModel;
    private final DataImportIssueStore issueStore;
    private final ServiceDateInterval transitPeriodLimit;
    private final List<NetexBundle> netexBundles;

    public NetexModule(Graph graph, TransitModel transitModel, DataImportIssueStore issueStore, int subwayAccessTime, ServiceDateInterval transitPeriodLimit, List<NetexBundle> netexBundles) {
        this.graph = graph;
        this.transitModel = transitModel;
        this.issueStore = issueStore;
        this.subwayAccessTime = subwayAccessTime;
        this.transitPeriodLimit = transitPeriodLimit;
        this.netexBundles = netexBundles;
    }

    @Override
    public void buildGraph() {
        try {
            CalendarServiceData calendarServiceData = new CalendarServiceData();
            boolean hasActiveTransit = false;
            for (NetexBundle netexBundle : this.netexBundles) {
                netexBundle.checkInputs();
                OtpTransitServiceBuilder transitBuilder = netexBundle.loadBundle(this.graph.deduplicator, this.issueStore);
                transitBuilder.limitServiceDays(this.transitPeriodLimit);
                for (TripOnServiceDate tripOnServiceDate : transitBuilder.getTripOnServiceDates().values()) {
                    this.transitModel.getTripOnServiceDates().put(tripOnServiceDate.getId(), tripOnServiceDate);
                }
                calendarServiceData.add(transitBuilder.buildCalendarServiceData());
                if (OTPFeature.FlexRouting.isOn()) {
                    transitBuilder.getFlexTripsById().addAll(FlexTripsMapper.createFlexTrips(transitBuilder, this.issueStore));
                }
                this.validateStopTimesForEachTrip(transitBuilder.getStopTimesSortedByTrip());
                OtpTransitService otpService = transitBuilder.build();
                hasActiveTransit = hasActiveTransit || otpService.hasActiveTransit();
                this.transitModel.getOperators().addAll(otpService.getAllOperators());
                this.transitModel.addNoticeAssignments(otpService.getNoticeAssignments());
                AddTransitModelEntitiesToGraph.addToGraph(otpService, this.subwayAccessTime, this.graph, this.transitModel);
                this.transitModel.validateTimeZones();
            }
            this.transitModel.updateCalendarServiceData(hasActiveTransit, calendarServiceData, this.issueStore);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void validateStopTimesForEachTrip(TripStopTimes stopTimesByTrip) {
        new ValidateAndInterpolateStopTimesForEachTrip(stopTimesByTrip, false, false, this.issueStore).run();
    }

    @Override
    public void checkInputs() {
        this.netexBundles.forEach(NetexBundle::checkInputs);
    }
}

