/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.projectinfo;

import java.io.InputStream;
import java.util.Properties;
import org.opentripplanner.model.projectinfo.GraphFileHeader;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.model.projectinfo.VersionControlInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OtpProjectInfoParser {
    private static final Logger LOG = LoggerFactory.getLogger(OtpProjectInfo.class);
    private static final String FILENAME = "otp-project-info.properties";

    OtpProjectInfoParser() {
    }

    static OtpProjectInfo loadFromProperties() {
        try {
            InputStream in = OtpProjectInfo.class.getClassLoader().getResourceAsStream(FILENAME);
            Properties props = new Properties();
            props.load(in);
            OtpProjectInfo version = new OtpProjectInfo(OtpProjectInfoParser.normalize(props.getProperty("project.version")), new GraphFileHeader(OtpProjectInfoParser.get(props, "otp.serialization.version.id")), new VersionControlInfo(OtpProjectInfoParser.get(props, "git.commit.id"), OtpProjectInfoParser.get(props, "git.branch"), OtpProjectInfoParser.get(props, "git.commit.time"), OtpProjectInfoParser.get(props, "git.build.time"), OtpProjectInfoParser.getBool(props, "git.dirty")));
            LOG.debug("Parsed Maven artifact version: {}", (Object)version);
            return version;
        }
        catch (Exception e) {
            LOG.error("Error reading version from properties file: {}", (Object)e.getMessage());
            return new OtpProjectInfo();
        }
    }

    private static String get(Properties props, String key) {
        return OtpProjectInfoParser.normalize(props.getProperty(key));
    }

    private static boolean getBool(Properties props, String key) {
        return "true".equalsIgnoreCase(props.getProperty(key, "true"));
    }

    private static String normalize(String text) {
        if (text == null || text.isBlank()) {
            return "UNKNOWN";
        }
        if (text.startsWith("${") && text.endsWith("}")) {
            return "UNKNOWN";
        }
        return text;
    }
}

