/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.legreference;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Base64;
import javax.annotation.Nullable;
import org.opentripplanner.model.plan.legreference.LegReference;
import org.opentripplanner.model.plan.legreference.LegReferenceType;
import org.opentripplanner.model.plan.legreference.ScheduledTransitLegReference;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegReferenceSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(LegReferenceSerializer.class);
    private static final DateTimeFormatter LENIENT_ISO_LOCAL_DATE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).optionalStart().appendLiteral('-').optionalEnd().appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('-').optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();

    private LegReferenceSerializer() {
    }

    @Nullable
    public static String encode(LegReference legReference) {
        String string;
        if (legReference == null) {
            return null;
        }
        LegReferenceType typeEnum = LegReferenceType.forClass(legReference.getClass());
        if (typeEnum == null) {
            throw new IllegalArgumentException("Unknown LegReference type");
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buf);
        try {
            LegReferenceSerializer.writeEnum(typeEnum, out);
            typeEnum.getSerializer().write(legReference, out);
            out.flush();
            string = Base64.getUrlEncoder().encodeToString(buf.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Failed to encode leg reference", (Throwable)e);
                return null;
            }
        }
        out.close();
        return string;
    }

    @Nullable
    public static LegReference decode(String legReference) {
        LegReference legReference2;
        if (legReference == null) {
            return null;
        }
        byte[] buf = Base64.getUrlDecoder().decode(legReference);
        ByteArrayInputStream input = new ByteArrayInputStream(buf);
        ObjectInputStream in = new ObjectInputStream(input);
        try {
            LegReferenceType type = LegReferenceSerializer.readEnum(in, LegReferenceType.class);
            legReference2 = type.getDeserializer().read(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParseException e) {
                LOG.error("Unable to decode leg reference: '" + legReference + "'", (Throwable)e);
                return null;
            }
        }
        in.close();
        return legReference2;
    }

    static void writeScheduledTransitLeg(LegReference ref, ObjectOutputStream out) throws IOException {
        if (!(ref instanceof ScheduledTransitLegReference)) {
            throw new IllegalArgumentException("Invalid LegReference type");
        }
        ScheduledTransitLegReference s = (ScheduledTransitLegReference)ref;
        out.writeUTF(s.tripId().toString());
        out.writeUTF(s.serviceDate().toString());
        out.writeInt(s.fromStopPositionInPattern());
        out.writeInt(s.toStopPositionInPattern());
    }

    static LegReference readScheduledTransitLeg(ObjectInputStream objectInputStream) throws IOException {
        return new ScheduledTransitLegReference(FeedScopedId.parseId(objectInputStream.readUTF()), LocalDate.parse(objectInputStream.readUTF(), LENIENT_ISO_LOCAL_DATE), objectInputStream.readInt(), objectInputStream.readInt());
    }

    private static <T extends Enum<T>> void writeEnum(T value, ObjectOutputStream out) throws IOException {
        out.writeUTF(value.name());
    }

    private static <T extends Enum<T>> T readEnum(ObjectInputStream in, Class<T> enumType) throws IOException {
        String value = in.readUTF();
        return Enum.valueOf(enumType, value);
    }
}

