/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.lang.DoubleUtils;
import org.opentripplanner.model.plan.AbsoluteDirection;
import org.opentripplanner.model.plan.ElevationProfile;
import org.opentripplanner.model.plan.RelativeDirection;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.note.StreetNote;

public class WalkStep {
    private double distance = 0.0;
    private RelativeDirection relativeDirection;
    private I18NString streetName;
    private AbsoluteDirection absoluteDirection;
    private final Set<StreetNote> streetNotes = new HashSet<StreetNote>();
    private final Boolean area;
    private final Boolean bogusName;
    private final WgsCoordinate startLocation;
    private final double angle;
    private final boolean walkingBike;
    private String exit;
    private ElevationProfile elevationProfile;
    private Boolean stayOn = false;
    private List<Edge> edges = new ArrayList<Edge>();

    public WalkStep(I18NString streetName, WgsCoordinate startLocation, boolean bogusName, double angle, boolean walkingBike, boolean area) {
        this.streetName = streetName;
        this.startLocation = startLocation;
        this.bogusName = bogusName;
        this.angle = DoubleUtils.roundTo2Decimals(angle);
        this.walkingBike = walkingBike;
        this.area = area;
    }

    public void setDirections(double lastAngle, double thisAngle, boolean roundabout) {
        this.relativeDirection = RelativeDirection.calculate(lastAngle, thisAngle, roundabout);
        this.setAbsoluteDirection(thisAngle);
    }

    public void setAbsoluteDirection(double thisAngle) {
        int octant = (int)(8L + Math.round(thisAngle * 8.0 / (Math.PI * 2))) % 8;
        this.absoluteDirection = AbsoluteDirection.values()[octant];
    }

    public ElevationProfile getElevationProfile() {
        return this.elevationProfile;
    }

    public void addElevation(ElevationProfile other) {
        if (other == null) {
            return;
        }
        this.elevationProfile = this.elevationProfile == null ? other : this.elevationProfile.add(other);
    }

    public void addStreetNotes(Collection<StreetNote> streetNotes) {
        if (streetNotes == null) {
            return;
        }
        this.streetNotes.addAll(streetNotes);
    }

    public String streetNameNoParens() {
        String str = this.streetName.toString();
        if (str == null) {
            return null;
        }
        int idx = str.indexOf(40);
        if (idx > 0) {
            return str.substring(0, idx - 1);
        }
        return str;
    }

    public Set<StreetNote> getStreetNotes() {
        return this.streetNotes;
    }

    public double getDistance() {
        return this.distance;
    }

    public void addDistance(double distance) {
        this.distance = DoubleUtils.roundTo2Decimals(this.distance + distance);
    }

    public RelativeDirection getRelativeDirection() {
        return this.relativeDirection;
    }

    public void setRelativeDirection(RelativeDirection relativeDirection) {
        this.relativeDirection = relativeDirection;
    }

    public I18NString getStreetName() {
        return this.streetName;
    }

    public void setStreetName(I18NString streetName) {
        this.streetName = streetName;
    }

    public AbsoluteDirection getAbsoluteDirection() {
        return this.absoluteDirection;
    }

    public void setAbsoluteDirection(AbsoluteDirection absoluteDirection) {
        this.absoluteDirection = absoluteDirection;
    }

    public String getExit() {
        return this.exit;
    }

    public void setExit(String exit) {
        this.exit = exit;
    }

    public Boolean getStayOn() {
        return this.stayOn;
    }

    public void setStayOn(Boolean stayOn) {
        this.stayOn = stayOn;
    }

    public Boolean getArea() {
        return this.area;
    }

    public Boolean getBogusName() {
        return this.bogusName;
    }

    public WgsCoordinate getStartLocation() {
        return this.startLocation;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean isWalkingBike() {
        return this.walkingBike;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    public String toString() {
        String direction = this.absoluteDirection.toString();
        if (this.relativeDirection != null) {
            direction = this.relativeDirection.toString();
        }
        return "WalkStep(" + direction + " on " + this.streetName + " for " + this.distance + ")";
    }
}

