/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.ZonedDateTime;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.time.DurationUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;

public class UnknownTransitPathLeg
implements Leg {
    private final Place from;
    private final Place to;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final int nTransfers;

    public UnknownTransitPathLeg(Place from, Place to, ZonedDateTime startTime, ZonedDateTime endTime, int nTransfers) {
        this.from = from;
        this.to = to;
        this.startTime = startTime;
        this.endTime = endTime;
        this.nTransfers = nTransfers;
    }

    @Override
    public Place getFrom() {
        return this.from;
    }

    @Override
    public Place getTo() {
        return this.to;
    }

    @Override
    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public ZonedDateTime getEndTime() {
        return this.endTime;
    }

    @Override
    public boolean isTransitLeg() {
        return false;
    }

    @Override
    public boolean hasSameMode(Leg other) {
        return false;
    }

    @Override
    public double getDistanceMeters() {
        return -1.0;
    }

    @Override
    public LineString getLegGeometry() {
        return null;
    }

    @Override
    public int getGeneralizedCost() {
        return 0;
    }

    public int getNumberOfTransfers() {
        return this.nTransfers;
    }

    public String description() {
        return "Unknown transit " + this.nTransfers + "tx " + DurationUtils.durationToStr(this.getDuration());
    }

    public String toString() {
        return ToStringBuilder.of(UnknownTransitPathLeg.class).addObj("from", this.from).addObj("to", this.to).addTime("startTime", this.startTime).addTime("endTime", this.endTime).addNum("numOfTransfers", this.nTransfers).toString();
    }
}

