/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.TripTimes;

public class FrequencyTransitLeg
extends ScheduledTransitLeg {
    private final int frequencyHeadwayInSeconds;

    public FrequencyTransitLeg(TripTimes tripTimes, TripPattern tripPattern, int boardStopIndexInPattern, int alightStopIndexInPattern, ZonedDateTime startTime, ZonedDateTime endTime, LocalDate serviceDate, ZoneId zoneId, ConstrainedTransfer transferFromPreviousLeg, ConstrainedTransfer transferToNextLeg, int generalizedCost, int frequencyHeadwayInSeconds, @Nullable Float accessibilityScore) {
        super(tripTimes, tripPattern, boardStopIndexInPattern, alightStopIndexInPattern, startTime, endTime, serviceDate, zoneId, transferFromPreviousLeg, transferToNextLeg, generalizedCost, accessibilityScore);
        this.frequencyHeadwayInSeconds = frequencyHeadwayInSeconds;
    }

    @Override
    public Boolean getNonExactFrequency() {
        return this.frequencyHeadwayInSeconds != 0;
    }

    @Override
    public Integer getHeadway() {
        return this.frequencyHeadwayInSeconds;
    }

    @Override
    public boolean isPartiallySameTransitLeg(Leg other) {
        boolean same = super.isPartiallySameTransitLeg(other);
        if (other instanceof FrequencyTransitLeg) {
            FrequencyTransitLeg frequencyTransitLeg = (FrequencyTransitLeg)other;
            int start = this.getTripTimes().getDepartureTime(0);
            int otherStart = frequencyTransitLeg.getTripTimes().getDepartureTime(0);
            return same && start == otherStart;
        }
        return same;
    }

    @Override
    public List<StopArrival> getIntermediateStops() {
        ArrayList<StopArrival> visits = new ArrayList<StopArrival>();
        for (int i = this.boardStopPosInPattern + 1; i < this.alightStopPosInPattern; ++i) {
            StopLocation stop = this.tripPattern.getStop(i);
            int arrivalTime = this.tripTimes.getArrivalTime(i);
            int departureTime = this.tripTimes.getDepartureTime(i) + this.frequencyHeadwayInSeconds;
            StopArrival visit = new StopArrival(Place.forStop(stop), ServiceDateUtils.toZonedDateTime(this.serviceDate, this.zoneId, arrivalTime), ServiceDateUtils.toZonedDateTime(this.serviceDate, this.zoneId, departureTime), i, this.tripTimes.getOriginalGtfsStopSequence(i));
            visits.add(visit);
        }
        return visits;
    }

    @Override
    public ScheduledTransitLeg withAccessibilityScore(Float score) {
        return new FrequencyTransitLeg(this.tripTimes, this.tripPattern, this.boardStopPosInPattern, this.alightStopPosInPattern, this.getStartTime(), this.getEndTime(), this.serviceDate, this.zoneId, this.getTransferFromPrevLeg(), this.getTransferToNextLeg(), this.getGeneralizedCost(), this.frequencyHeadwayInSeconds, score);
    }
}

