/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.modes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.model.modes.AllowAllModesFilter;
import org.opentripplanner.model.modes.AllowMainAndSubModeFilter;
import org.opentripplanner.model.modes.AllowMainAndSubModesFilter;
import org.opentripplanner.model.modes.AllowMainModeFilter;
import org.opentripplanner.model.modes.AllowMainModesFilter;
import org.opentripplanner.model.modes.AllowTransitModeFilter;
import org.opentripplanner.model.modes.FilterCollection;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.basic.TransitMode;

class FilterFactory {
    private static final AllowAllModesFilter ALLOWED_ALL_TRANSIT_MODES = new AllowAllModesFilter();

    private FilterFactory() {
    }

    static AllowTransitModeFilter of(MainAndSubMode mode) {
        if (mode.subMode() == null) {
            return new AllowMainModeFilter(mode.mainMode());
        }
        return new AllowMainAndSubModeFilter(mode);
    }

    static AllowTransitModeFilter create(Collection<MainAndSubMode> allowedModes) {
        List<AllowTransitModeFilter> filters = allowedModes.stream().map(FilterFactory::of).toList();
        if (filters.isEmpty()) {
            throw new IllegalArgumentException("Can not match an empty set of modes!");
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        Map<Class<?>, List<AllowTransitModeFilter>> map = filters.stream().collect(Collectors.groupingBy(Object::getClass));
        if (map.containsKey(AllowAllModesFilter.class)) {
            return ALLOWED_ALL_TRANSIT_MODES;
        }
        ArrayList<AllowTransitModeFilter> result = new ArrayList<AllowTransitModeFilter>();
        Set<AllowMainModeFilter> mainModeFilters = FilterFactory.stream(map, AllowMainModeFilter.class).collect(Collectors.toSet());
        if (mainModeFilters.size() == TransitMode.values().length) {
            return ALLOWED_ALL_TRANSIT_MODES;
        }
        if (mainModeFilters.size() == 1) {
            result.addAll(mainModeFilters);
        } else if (mainModeFilters.size() > 1) {
            result.add(new AllowMainModesFilter(mainModeFilters));
        }
        Map<TransitMode, List<AllowMainAndSubModeFilter>> subModeFiltersByMainMode = FilterFactory.stream(map, AllowMainAndSubModeFilter.class).collect(Collectors.groupingBy(AllowMainAndSubModeFilter::mainMode));
        EnumSet<TransitMode> mainModes = mainModeFilters.isEmpty() ? EnumSet.noneOf(TransitMode.class) : EnumSet.copyOf(mainModeFilters.stream().map(AllowMainModeFilter::mainMode).toList());
        for (TransitMode mainMode : subModeFiltersByMainMode.keySet()) {
            if (mainModes.contains((Object)mainMode)) continue;
            List<AllowMainAndSubModeFilter> subModeFilters = subModeFiltersByMainMode.get((Object)mainMode);
            if (subModeFilters.size() == 1) {
                result.addAll(subModeFilters);
                continue;
            }
            if (subModeFilters.size() <= 1) continue;
            result.add(new AllowMainAndSubModesFilter(subModeFilters));
        }
        if (result.size() == 1) {
            return (AllowTransitModeFilter)result.get(0);
        }
        return new FilterCollection(result.stream().distinct().toList());
    }

    private static <T> Stream<T> stream(Map<Class<?>, List<AllowTransitModeFilter>> map, Class<T> type) {
        List<AllowTransitModeFilter> list = map.get(type);
        return list == null ? Stream.empty() : list.stream().map(it -> it);
    }
}

