/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar.openinghours;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.opentripplanner.model.calendar.openinghours.OHCalendar;
import org.opentripplanner.model.calendar.openinghours.OpeningHours;
import org.opentripplanner.transit.model.framework.Deduplicator;

public class OHCalendarBuilder {
    private final Deduplicator deduplicator;
    private final LocalDate startOfPeriod;
    private final LocalDate endOfPeriod;
    private final int daysInPeriod;
    private final ZoneId zoneId;
    private final List<OpeningHours> openingHours = new ArrayList<OpeningHours>();

    public OHCalendarBuilder(Deduplicator deduplicator, LocalDate startOfPeriod, int daysInPeriod, ZoneId zoneId) {
        this.deduplicator = deduplicator;
        this.startOfPeriod = startOfPeriod;
        this.endOfPeriod = startOfPeriod.plusDays(daysInPeriod);
        this.daysInPeriod = daysInPeriod;
        this.zoneId = zoneId;
    }

    public OpeningHoursBuilder openingHours(String periodDescription, LocalTime startTime, LocalTime endTime) {
        return new OpeningHoursBuilder(periodDescription, startTime, endTime, false);
    }

    public OpeningHoursBuilder openingHours(String periodDescription, LocalTime startTime, LocalTime endTime, boolean isAfterMidnight) {
        return new OpeningHoursBuilder(periodDescription, startTime, endTime, isAfterMidnight);
    }

    public OHCalendar build() {
        Collections.sort(this.openingHours);
        return new OHCalendar(this.startOfPeriod, this.endOfPeriod, this.zoneId, this.deduplicator.deduplicateImmutableList(OpeningHours.class, this.openingHours));
    }

    public class OpeningHoursBuilder {
        private String periodDescription;
        private final LocalTime startTime;
        private final LocalTime endTime;
        private boolean afterMidnight;
        private final BitSet openingDays;

        public OpeningHoursBuilder(String periodDescription, LocalTime startTime, LocalTime endTime, boolean afterMidnight) {
            this.openingDays = new BitSet(OHCalendarBuilder.this.daysInPeriod);
            this.periodDescription = periodDescription;
            this.startTime = startTime;
            this.endTime = endTime;
            this.afterMidnight = afterMidnight;
        }

        public boolean isAfterMidnight() {
            return this.afterMidnight;
        }

        public boolean isEverOn() {
            return !this.openingDays.isEmpty();
        }

        public OpeningHoursBuilder on(LocalDate date) {
            LocalDate shiftedDate = date.plusDays(this.afterMidnight ? 1L : 0L);
            if (shiftedDate.isBefore(OHCalendarBuilder.this.startOfPeriod) || shiftedDate.isAfter(OHCalendarBuilder.this.endOfPeriod)) {
                return this;
            }
            this.openingDays.set((int)ChronoUnit.DAYS.between(OHCalendarBuilder.this.startOfPeriod, shiftedDate));
            return this;
        }

        public OpeningHoursBuilder on(DayOfWeek dayOfWeek) {
            int firstOccurrenceDaysFromStart;
            DayOfWeek shiftedDayOfWeek = dayOfWeek.plus(this.afterMidnight ? 1L : 0L);
            int rawWeekDayDifference = shiftedDayOfWeek.getValue() - OHCalendarBuilder.this.startOfPeriod.getDayOfWeek().getValue();
            for (int i = firstOccurrenceDaysFromStart = rawWeekDayDifference >= 0 ? rawWeekDayDifference : 7 - Math.abs(rawWeekDayDifference); i < OHCalendarBuilder.this.daysInPeriod; i += 7) {
                this.openingDays.set(i);
            }
            return this;
        }

        public OpeningHoursBuilder on(DayOfWeek fromDayOfWeek, DayOfWeek untilDayOfWeek) {
            if (fromDayOfWeek == null) {
                return this;
            }
            if (untilDayOfWeek == null) {
                this.on(fromDayOfWeek);
                return this;
            }
            int untilAdjusted = fromDayOfWeek.getValue() > untilDayOfWeek.getValue() ? untilDayOfWeek.getValue() + 7 : untilDayOfWeek.getValue();
            for (int i = fromDayOfWeek.getValue(); i <= untilAdjusted; ++i) {
                int dayValue = i > 7 ? i - 7 : i;
                this.on(DayOfWeek.of(dayValue));
            }
            return this;
        }

        public OpeningHoursBuilder on(Month fromMonth, Month untilMonth, DayOfWeek fromDayOfWeek, DayOfWeek untilDayOfWeek) {
            int i;
            if (fromMonth == null || fromDayOfWeek == null) {
                return this;
            }
            HashSet<Month> months = new HashSet<Month>();
            if (untilMonth == null) {
                months.add(fromMonth);
            } else {
                int untilMonthAdjusted = fromMonth.getValue() > untilMonth.getValue() ? untilMonth.getValue() + 12 : untilMonth.getValue();
                for (int i2 = fromMonth.getValue(); i2 <= untilMonthAdjusted; ++i2) {
                    int monthValue = i2 > 12 ? i2 - 12 : i2;
                    months.add(Month.of(monthValue));
                }
            }
            HashSet<DayOfWeek> daysOfWeek = new HashSet<DayOfWeek>();
            if (untilDayOfWeek == null) {
                daysOfWeek.add(fromDayOfWeek);
            } else {
                int untilDayAdjusted = fromDayOfWeek.getValue() > untilDayOfWeek.getValue() ? untilDayOfWeek.getValue() + 7 : untilDayOfWeek.getValue();
                for (i = fromDayOfWeek.getValue(); i <= untilDayAdjusted; ++i) {
                    int dayValue = i > 7 ? i - 7 : i;
                    daysOfWeek.add(DayOfWeek.of(dayValue));
                }
            }
            LocalDate dateToProcess = this.afterMidnight ? OHCalendarBuilder.this.startOfPeriod.minusDays(1L) : OHCalendarBuilder.this.startOfPeriod;
            i = 0;
            while (i < OHCalendarBuilder.this.daysInPeriod) {
                if (months.contains(dateToProcess.getMonth())) {
                    if (daysOfWeek.contains(dateToProcess.getDayOfWeek())) {
                        this.openingDays.set(i);
                    }
                    dateToProcess = dateToProcess.plusDays(1L);
                    ++i;
                    continue;
                }
                int daysToSkip = YearMonth.of(dateToProcess.getYear(), dateToProcess.getMonth()).lengthOfMonth() - dateToProcess.getDayOfMonth() + 1;
                dateToProcess = dateToProcess.plusDays(daysToSkip);
                i += daysToSkip;
            }
            return this;
        }

        public OpeningHoursBuilder everyDay() {
            this.openingDays.set(0, OHCalendarBuilder.this.daysInPeriod);
            return this;
        }

        public OpeningHoursBuilder offWithTimeShift(OpeningHoursBuilder otherBuilder) {
            BitSet daysOff = otherBuilder.getOpeningDays();
            String offDescription = otherBuilder.getPeriodDescription();
            if (this.afterMidnight) {
                boolean intersects = false;
                for (int i = 1; i < OHCalendarBuilder.this.daysInPeriod; ++i) {
                    if (this.openingDays.get(i) && daysOff.get(i - 1)) {
                        intersects = true;
                        this.openingDays.clear(i);
                    }
                    if (!intersects) continue;
                    this.appendDescription(" except " + offDescription);
                }
            } else {
                this.off(daysOff, offDescription);
            }
            return this;
        }

        public OpeningHoursBuilderAndNewBuilders createBuildersForRelativeComplement(OpeningHoursBuilder otherBuilder) {
            LocalTime otherStartTime = otherBuilder.getStartTime();
            LocalTime otherEndTime = otherBuilder.getEndTime();
            if (otherEndTime.equals(this.startTime) || otherEndTime.isBefore(this.startTime) || this.endTime.equals(otherStartTime) || this.endTime.isBefore(otherStartTime)) {
                return new OpeningHoursBuilderAndNewBuilders(this, List.of());
            }
            String offDescription = otherBuilder.getPeriodDescription();
            if ((otherStartTime.isBefore(this.startTime) || otherStartTime.equals(this.startTime)) && (this.endTime.isBefore(otherEndTime) || this.endTime.equals(otherEndTime))) {
                this.off(otherBuilder.getOpeningDays(), offDescription);
                return new OpeningHoursBuilderAndNewBuilders(this, List.of());
            }
            BitSet commonDays = this.getCommonDays(otherBuilder);
            if (commonDays.isEmpty()) {
                return new OpeningHoursBuilderAndNewBuilders(this, List.of());
            }
            String newDescription = String.format("Days overlapping between %s and %s", this.getPeriodDescription(), otherBuilder.getPeriodDescription());
            if (otherStartTime.equals(this.startTime) || otherStartTime.isBefore(this.startTime)) {
                OpeningHoursBuilder newOpeningHoursBuilder = OHCalendarBuilder.this.openingHours(newDescription, otherEndTime, this.endTime);
                newOpeningHoursBuilder.on(commonDays);
                this.off(commonDays, offDescription);
                return new OpeningHoursBuilderAndNewBuilders(this, List.of(newOpeningHoursBuilder));
            }
            if (this.endTime.equals(otherEndTime) || this.endTime.isBefore(otherEndTime)) {
                OpeningHoursBuilder newOpeningHoursBuilder = OHCalendarBuilder.this.openingHours(newDescription, this.startTime, otherStartTime);
                newOpeningHoursBuilder.on(commonDays);
                this.off(commonDays, offDescription);
                return new OpeningHoursBuilderAndNewBuilders(this, List.of(newOpeningHoursBuilder));
            }
            OpeningHoursBuilder firstNewOpeningHoursBuilder = OHCalendarBuilder.this.openingHours(newDescription, this.startTime, otherStartTime);
            firstNewOpeningHoursBuilder.on(commonDays);
            OpeningHoursBuilder secondNewOpeningHoursBuilder = OHCalendarBuilder.this.openingHours(newDescription, otherEndTime, this.endTime);
            secondNewOpeningHoursBuilder.on(commonDays);
            this.off(commonDays, offDescription);
            return new OpeningHoursBuilderAndNewBuilders(this, List.of(firstNewOpeningHoursBuilder, secondNewOpeningHoursBuilder));
        }

        public OHCalendarBuilder add() {
            BitSet days = OHCalendarBuilder.this.deduplicator.deduplicateBitSet(this.openingDays);
            OpeningHours hours = OHCalendarBuilder.this.deduplicator.deduplicateObject(OpeningHours.class, new OpeningHours(this.periodDescription, this.startTime, this.endTime, days));
            OHCalendarBuilder.this.openingHours.add(hours);
            return OHCalendarBuilder.this;
        }

        private BitSet getOpeningDays() {
            return this.openingDays;
        }

        private String getPeriodDescription() {
            return this.periodDescription;
        }

        private LocalTime getStartTime() {
            return this.startTime;
        }

        private LocalTime getEndTime() {
            return this.endTime;
        }

        private BitSet getCommonDays(OpeningHoursBuilder otherBuilder) {
            BitSet openingDaysClone = (BitSet)this.openingDays.clone();
            openingDaysClone.and(otherBuilder.getOpeningDays());
            return openingDaysClone;
        }

        private void appendDescription(String descriptionAddition) {
            this.periodDescription = this.periodDescription + descriptionAddition;
        }

        private OpeningHoursBuilder on(BitSet days) {
            if (days.size() != this.openingDays.size()) {
                return this;
            }
            this.openingDays.or(days);
            return this;
        }

        private OpeningHoursBuilder off(BitSet daysOff, String offDescription) {
            if (this.openingDays.intersects(daysOff)) {
                this.openingDays.andNot(daysOff);
                this.appendDescription(" except " + offDescription);
            }
            return this;
        }
    }

    public record OpeningHoursBuilderAndNewBuilders(OpeningHoursBuilder originalBuilder, List<OpeningHoursBuilder> newBuilders) {
    }
}

