/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public final class ServiceCalendarDate
implements Serializable,
Comparable<ServiceCalendarDate> {
    public static final int EXCEPTION_TYPE_ADD = 1;
    public static final int EXCEPTION_TYPE_REMOVE = 2;
    private final FeedScopedId serviceId;
    private final LocalDate date;
    private final int exceptionType;

    public ServiceCalendarDate(FeedScopedId serviceId, LocalDate date, int exceptionType) {
        this.serviceId = serviceId;
        this.date = date;
        this.exceptionType = exceptionType;
    }

    public static ServiceCalendarDate create(FeedScopedId serviceId, LocalDate date) {
        return new ServiceCalendarDate(serviceId, date, 1);
    }

    public FeedScopedId getServiceId() {
        return this.serviceId;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public int getExceptionType() {
        return this.exceptionType;
    }

    public int hashCode() {
        return Objects.hash(this.serviceId, this.date);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCalendarDate that = (ServiceCalendarDate)o;
        return Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.date, that.date);
    }

    public String toString() {
        return ToStringBuilder.of(ServiceCalendarDate.class).addObj("serviceId", this.serviceId).addObj("date", this.date).addObj("exception", this.exceptionType).toString();
    }

    @Override
    public int compareTo(ServiceCalendarDate other) {
        int c = this.serviceId.compareTo(other.serviceId);
        if (c == 0) {
            c = this.date.compareTo(other.date);
        }
        return c;
    }
}

