/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import javax.annotation.Nullable;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;

public record UpdateError(@Nullable FeedScopedId tripId, UpdateErrorType errorType, @Nullable Integer stopIndex) {
    public UpdateError(@Nullable FeedScopedId tripId, UpdateErrorType errorType) {
        this(tripId, errorType, null);
    }

    public String debugId() {
        if (this.tripId == null) {
            return "no trip id";
        }
        if (this.stopIndex == null) {
            return this.tripId.toString();
        }
        return "%s{stopIndex=%s}".formatted(this.tripId, this.stopIndex);
    }

    public static <T> Result<T, UpdateError> result(FeedScopedId tripId, UpdateErrorType errorType) {
        return Result.failure(new UpdateError(tripId, errorType));
    }

    public static UpdateError noTripId(UpdateErrorType errorType) {
        return new UpdateError(null, errorType);
    }

    public static enum UpdateErrorType {
        UNKNOWN,
        INVALID_INPUT_STRUCTURE,
        TRIP_NOT_FOUND,
        TRIP_NOT_FOUND_IN_PATTERN,
        NO_FUZZY_TRIP_MATCH,
        NO_TRIP_FOR_CANCELLATION_FOUND,
        TRIP_ALREADY_EXISTS,
        NO_START_DATE,
        NO_UPDATES,
        NO_TRIP_ID,
        TOO_FEW_STOPS,
        NO_VALID_STOPS,
        NO_SERVICE_ON_DATE,
        INVALID_ARRIVAL_TIME,
        INVALID_DEPARTURE_TIME,
        NEGATIVE_DWELL_TIME,
        NEGATIVE_HOP_TIME,
        INVALID_STOP_SEQUENCE,
        NOT_IMPLEMENTED_UNSCHEDULED,
        NOT_IMPLEMENTED_DUPLICATED,
        NOT_MONITORED;

    }
}

