/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.model.UpdateSuccess;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerUpdater;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimetableSnapshot {
    private static final Logger LOG = LoggerFactory.getLogger(TimetableSnapshot.class);
    private final Set<Timetable> dirtyTimetables = new HashSet<Timetable>();
    private HashMap<TripPattern, SortedSet<Timetable>> timetables = new HashMap();
    private HashMap<TripIdAndServiceDate, TripPattern> realtimeAddedTripPattern = new HashMap();
    private HashMap<FeedScopedId, TripOnServiceDate> realtimeAddedTripOnServiceDate = new HashMap();
    private HashMap<TripIdAndServiceDate, TripOnServiceDate> realtimeAddedTripOnServiceDateByTripIdAndServiceDate = new HashMap();
    private SetMultimap<StopLocation, TripPattern> patternsForStop = HashMultimap.create();
    private boolean readOnly = false;
    private boolean dirty = false;

    public Timetable resolve(TripPattern pattern, LocalDate serviceDate) {
        SortedSet<Timetable> sortedTimetables = this.timetables.get(pattern);
        if (sortedTimetables != null && serviceDate != null) {
            for (Timetable timetable : sortedTimetables) {
                if (timetable == null || !timetable.isValidFor(serviceDate)) continue;
                return timetable;
            }
        }
        return pattern.getScheduledTimetable();
    }

    public void removeRealtimeUpdatedTripTimes(TripPattern tripPattern, FeedScopedId tripId, LocalDate serviceDate) {
        SortedSet<Timetable> sortedTimetables = this.timetables.get(tripPattern);
        if (sortedTimetables != null) {
            TripTimes tripTimesToRemove = null;
            for (Timetable timetable : sortedTimetables) {
                if (!timetable.isValidFor(serviceDate)) continue;
                TripTimes tripTimes = timetable.getTripTimes(tripId);
                if (tripTimes == null) {
                    LOG.debug("No triptimes to remove for trip {}", (Object)tripId);
                    continue;
                }
                if (tripTimesToRemove != null) {
                    LOG.debug("Found two triptimes to remove for trip {}", (Object)tripId);
                    continue;
                }
                tripTimesToRemove = tripTimes;
            }
            if (tripTimesToRemove != null) {
                for (Timetable sortedTimetable : sortedTimetables) {
                    boolean isDirty = sortedTimetable.getTripTimes().remove(tripTimesToRemove);
                    if (!isDirty) continue;
                    this.dirtyTimetables.add(sortedTimetable);
                }
            }
        }
    }

    public TripPattern getRealtimeAddedTripPattern(FeedScopedId tripId, LocalDate serviceDate) {
        TripIdAndServiceDate tripIdAndServiceDate = new TripIdAndServiceDate(tripId, serviceDate);
        return this.realtimeAddedTripPattern.get(tripIdAndServiceDate);
    }

    public boolean hasRealtimeAddedTripPatterns() {
        return !this.realtimeAddedTripPattern.isEmpty();
    }

    public Result<UpdateSuccess, UpdateError> update(TripPattern pattern, TripTimes updatedTripTimes, LocalDate serviceDate) {
        int tripIndex;
        Objects.requireNonNull(pattern);
        Objects.requireNonNull(serviceDate);
        if (this.readOnly) {
            throw new ConcurrentModificationException("This TimetableSnapshot is read-only.");
        }
        Timetable tt = this.resolve(pattern, serviceDate);
        if (!this.dirtyTimetables.contains(tt)) {
            Timetable old = tt;
            tt = new Timetable(tt, serviceDate);
            SortedSet<Timetable> sortedTimetables = this.timetables.get(pattern);
            if (sortedTimetables == null) {
                sortedTimetables = new TreeSet<Timetable>(new SortedTimetableComparator());
            } else {
                TreeSet<Timetable> temp = new TreeSet<Timetable>(new SortedTimetableComparator());
                temp.addAll(sortedTimetables);
                sortedTimetables = temp;
            }
            if (old.getServiceDate() != null) {
                sortedTimetables.remove(old);
            }
            sortedTimetables.add(tt);
            this.timetables.put(pattern, sortedTimetables);
            this.dirtyTimetables.add(tt);
            this.dirty = true;
        }
        if ((tripIndex = tt.getTripIndex(updatedTripTimes.getTrip().getId())) == -1) {
            tt.addTripTimes(updatedTripTimes);
        } else {
            tt.setTripTimes(tripIndex, updatedTripTimes);
        }
        if (pattern.isCreatedByRealtimeUpdater()) {
            FeedScopedId tripId = updatedTripTimes.getTrip().getId();
            TripIdAndServiceDate tripIdAndServiceDate = new TripIdAndServiceDate(tripId, serviceDate);
            this.realtimeAddedTripPattern.put(tripIdAndServiceDate, pattern);
        }
        this.addPatternToIndex(pattern);
        return Result.success(UpdateSuccess.noWarnings());
    }

    public TimetableSnapshot commit() {
        return this.commit(null, false);
    }

    public TimetableSnapshot commit(TransitLayerUpdater transitLayerUpdater, boolean force) {
        if (this.readOnly) {
            throw new ConcurrentModificationException("This TimetableSnapshot is read-only.");
        }
        TimetableSnapshot ret = new TimetableSnapshot();
        if (!force && !this.isDirty()) {
            return null;
        }
        ret.timetables = (HashMap)this.timetables.clone();
        ret.realtimeAddedTripPattern = (HashMap)this.realtimeAddedTripPattern.clone();
        if (transitLayerUpdater != null) {
            transitLayerUpdater.update(this.dirtyTimetables, this.timetables);
        }
        ret.realtimeAddedTripOnServiceDate = (HashMap)this.realtimeAddedTripOnServiceDate.clone();
        ret.realtimeAddedTripOnServiceDateByTripIdAndServiceDate = (HashMap)this.realtimeAddedTripOnServiceDateByTripIdAndServiceDate.clone();
        this.dirtyTimetables.clear();
        this.dirty = false;
        ret.setPatternsForStop((SetMultimap<StopLocation, TripPattern>)HashMultimap.create(this.patternsForStop));
        ret.readOnly = true;
        return ret;
    }

    public void clear(String feedId) {
        if (this.readOnly) {
            throw new ConcurrentModificationException("This TimetableSnapshot is read-only.");
        }
        boolean timetableWasModified = this.clearTimetable(feedId);
        boolean realtimeAddedWasModified = this.clearRealtimeAddedTripPattern(feedId);
        if (timetableWasModified || realtimeAddedWasModified) {
            this.dirty = true;
        }
    }

    public void removeLastAddedTripPattern(FeedScopedId feedScopedTripId, LocalDate serviceDate) {
        this.realtimeAddedTripPattern.remove(new TripIdAndServiceDate(feedScopedTripId, serviceDate));
    }

    public boolean purgeExpiredData(LocalDate serviceDate) {
        if (this.readOnly) {
            throw new ConcurrentModificationException("This TimetableSnapshot is read-only.");
        }
        boolean modified = false;
        Iterator<TripPattern> it = this.timetables.keySet().iterator();
        while (it.hasNext()) {
            TripPattern pattern = it.next();
            SortedSet<Timetable> sortedTimetables = this.timetables.get(pattern);
            TreeSet<Timetable> toKeepTimetables = new TreeSet<Timetable>(new SortedTimetableComparator());
            for (Timetable timetable : sortedTimetables) {
                if (serviceDate.compareTo(timetable.getServiceDate()) < 0) {
                    toKeepTimetables.add(timetable);
                    continue;
                }
                modified = true;
            }
            if (toKeepTimetables.isEmpty()) {
                it.remove();
                continue;
            }
            this.timetables.put(pattern, toKeepTimetables);
        }
        Iterator<Map.Entry<TripIdAndServiceDate, TripPattern>> iterator = this.realtimeAddedTripPattern.entrySet().iterator();
        while (iterator.hasNext()) {
            TripIdAndServiceDate tripIdAndServiceDate = iterator.next().getKey();
            if (serviceDate.compareTo(tripIdAndServiceDate.serviceDate()) < 0) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    public boolean isDirty() {
        if (this.readOnly) {
            return false;
        }
        return this.dirty;
    }

    public String toString() {
        String d = this.readOnly ? "committed" : String.format("%d dirty", this.dirtyTimetables.size());
        return String.format("Timetable snapshot: %d timetables (%s)", this.timetables.size(), d);
    }

    public Collection<TripPattern> getPatternsForStop(StopLocation stop) {
        return this.patternsForStop.get((Object)stop);
    }

    public void setPatternsForStop(SetMultimap<StopLocation, TripPattern> patternsForStop) {
        this.patternsForStop = patternsForStop;
    }

    public void addLastAddedTripOnServiceDate(TripOnServiceDate tripOnServiceDate) {
        this.realtimeAddedTripOnServiceDate.put(tripOnServiceDate.getId(), tripOnServiceDate);
        this.realtimeAddedTripOnServiceDateByTripIdAndServiceDate.put(tripOnServiceDate.getTripIdAndServiceDate(), tripOnServiceDate);
    }

    public HashMap<FeedScopedId, TripOnServiceDate> getRealtimeAddedTripOnServiceDate() {
        return this.realtimeAddedTripOnServiceDate;
    }

    public HashMap<TripIdAndServiceDate, TripOnServiceDate> getRealtimeAddedTripOnServiceDateByTripIdAndServiceDate() {
        return this.realtimeAddedTripOnServiceDateByTripIdAndServiceDate;
    }

    protected boolean clearTimetable(String feedId) {
        return this.timetables.keySet().removeIf(tripPattern -> feedId.equals(tripPattern.getFeedId()));
    }

    protected boolean clearRealtimeAddedTripPattern(String feedId) {
        return this.realtimeAddedTripPattern.keySet().removeIf(realtimeAddedTripPattern -> feedId.equals(realtimeAddedTripPattern.tripId().getFeedId()));
    }

    private void addPatternToIndex(TripPattern tripPattern) {
        if (tripPattern.isCreatedByRealtimeUpdater()) {
            for (StopLocation stop : tripPattern.getStops()) {
                this.patternsForStop.put((Object)stop, (Object)tripPattern);
            }
        }
    }

    protected static class SortedTimetableComparator
    implements Comparator<Timetable> {
        protected SortedTimetableComparator() {
        }

        @Override
        public int compare(Timetable t1, Timetable t2) {
            return t1.getServiceDate().compareTo(t2.getServiceDate());
        }
    }
}

