/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.vector;

import edu.colorado.cires.cmg.mvt.VectorTile;
import edu.colorado.cires.cmg.mvt.adapt.jts.JtsAdapter;
import edu.colorado.cires.cmg.mvt.adapt.jts.TileGeomResult;
import edu.colorado.cires.cmg.mvt.build.MvtLayerBuild;
import edu.colorado.cires.cmg.mvt.build.MvtLayerParams;
import edu.colorado.cires.cmg.mvt.build.MvtLayerProps;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opentripplanner.api.mapping.PropertyMapper;
import org.opentripplanner.framework.geometry.GeometryUtils;

public abstract class LayerBuilder<T> {
    private static final GeometryFactory GEOMETRY_FACTORY = GeometryUtils.getGeometryFactory();
    private final MvtLayerProps layerProps = new MvtLayerProps();
    private final VectorTile.Tile.Layer.Builder layerBuilder;
    private final PropertyMapper<T> mapper;
    private final double expansionFactor;

    public LayerBuilder(PropertyMapper<T> mapper, String layerName, double expansionFactor) {
        this.mapper = mapper;
        this.layerBuilder = MvtLayerBuild.newLayerBuilder((String)layerName, (MvtLayerParams)MvtLayerParams.DEFAULT);
        this.expansionFactor = expansionFactor;
    }

    protected abstract List<Geometry> getGeometries(Envelope var1);

    final VectorTile.Tile.Layer build(Envelope envelope) {
        Envelope query = new Envelope(envelope);
        query.expandBy(envelope.getWidth() * this.expansionFactor, envelope.getHeight() * this.expansionFactor);
        TileGeomResult tileGeom = JtsAdapter.createTileGeom(this.getGeometries(query), (Envelope)envelope, (Envelope)query, (GeometryFactory)GEOMETRY_FACTORY, (MvtLayerParams)MvtLayerParams.DEFAULT, g -> true);
        List features = JtsAdapter.toFeatures((Collection)tileGeom.mvtGeoms, (MvtLayerProps)this.layerProps, this.mapper);
        this.layerBuilder.addAllFeatures((Iterable)features);
        MvtLayerBuild.writeProps((VectorTile.Tile.Layer.Builder)this.layerBuilder, (MvtLayerProps)this.layerProps);
        return this.layerBuilder.build();
    }
}

