/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.raster;

import java.awt.Color;
import java.util.Optional;
import org.opentripplanner.inspector.raster.DefaultScalarColorPalette;
import org.opentripplanner.inspector.raster.EdgeVertexTileRenderer;
import org.opentripplanner.inspector.raster.ScalarColorPalette;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.ElevatorHopEdge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.model.basic.Accessibility;

public class WheelchairEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private static final Color NO_WHEELCHAIR_COLOR = Color.RED;
    private static final Color YES_WHEELCHAIR_COLOR = Color.GREEN;
    private static final Color NO_WHEELCHAIR_INFORMATION_COLOR = Color.ORANGE;
    private final ScalarColorPalette slopePalette;

    public WheelchairEdgeRenderer(RoutingPreferences routingPreferences) {
        this.slopePalette = new DefaultScalarColorPalette(0.0, routingPreferences.wheelchair().maxSlope(), 1.0);
    }

    @Override
    public Optional<EdgeVertexTileRenderer.EdgeVisualAttributes> renderEdge(Edge e) {
        if (e instanceof StreetEdge) {
            StreetEdge pse = (StreetEdge)e;
            if (!pse.isWheelchairAccessible()) {
                return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(NO_WHEELCHAIR_COLOR, "wheelchair=no");
            }
            return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(this.slopePalette.getColor(pse.getMaxSlope()), String.format("%.02f", pse.getMaxSlope()));
        }
        if (e instanceof ElevatorHopEdge) {
            ElevatorHopEdge ehe = (ElevatorHopEdge)e;
            if (!ehe.isWheelchairAccessible()) {
                return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(NO_WHEELCHAIR_COLOR, "wheelchair=no");
            }
            return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(Color.GREEN, "elevator");
        }
        return Optional.empty();
    }

    @Override
    public Optional<EdgeVertexTileRenderer.VertexVisualAttributes> renderVertex(Vertex v) {
        if (v instanceof TransitStopVertex) {
            Accessibility accessibility = ((TransitStopVertex)v).getStop().getWheelchairAccessibility();
            Color color = switch (accessibility) {
                default -> throw new IncompatibleClassChangeError();
                case Accessibility.NO_INFORMATION -> NO_WHEELCHAIR_INFORMATION_COLOR;
                case Accessibility.POSSIBLE -> YES_WHEELCHAIR_COLOR;
                case Accessibility.NOT_POSSIBLE -> NO_WHEELCHAIR_COLOR;
            };
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(color, v.getDefaultName());
        }
        return Optional.empty();
    }

    @Override
    public String getName() {
        return "Wheelchair access";
    }
}

