/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.raster;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opentripplanner.inspector.raster.DefaultScalarColorPalette;
import org.opentripplanner.inspector.raster.EdgeVertexTileRenderer;
import org.opentripplanner.inspector.raster.ScalarColorPalette;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.Vertex;

class ElevationEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private final ScalarColorPalette colorPalette;

    ElevationEdgeRenderer(Graph graph) {
        this.colorPalette = graph.hasElevation ? new DefaultScalarColorPalette(graph.minElevation, (graph.minElevation + graph.maxElevation) / 2.0, graph.maxElevation) : new DefaultScalarColorPalette(0.0, 0.0, 0.0);
    }

    @Override
    public Optional<EdgeVertexTileRenderer.EdgeVisualAttributes> renderEdge(Edge e) {
        return Optional.empty();
    }

    @Override
    public Optional<EdgeVertexTileRenderer.VertexVisualAttributes> renderVertex(Vertex v) {
        Double elevation = this.findElevationForVertex(v);
        if (elevation != null) {
            return Optional.of(new EdgeVertexTileRenderer.VertexVisualAttributes(this.colorPalette.getColor(elevation), elevation.toString()));
        }
        return Optional.empty();
    }

    @Override
    public String getName() {
        return "Elevation";
    }

    @Override
    public boolean hasEdgeSegments(Edge edge) {
        return true;
    }

    @Override
    public Iterable<EdgeVertexTileRenderer.EdgeSegmentColor> edgeSegments(Edge edge) {
        if (edge instanceof StreetEdge) {
            StreetEdge streetEdge = (StreetEdge)edge;
            if (streetEdge.hasElevationExtension()) {
                double edgeLength = edge.getDistanceMeters();
                Color color = Color.DARK_GRAY;
                ArrayList<EdgeVertexTileRenderer.EdgeSegmentColor> list = new ArrayList<EdgeVertexTileRenderer.EdgeSegmentColor>();
                PackedCoordinateSequence profile = streetEdge.getElevationProfile();
                for (int i = 0; i < profile.size(); ++i) {
                    Coordinate point = profile.getCoordinate(i);
                    if (i != 0) {
                        list.add(new EdgeVertexTileRenderer.EdgeSegmentColor(point.x / edgeLength, color));
                    }
                    color = this.colorPalette.getColor(point.y);
                }
                return list;
            }
            return List.of(new EdgeVertexTileRenderer.EdgeSegmentColor(1.0, Color.GRAY));
        }
        return List.of(new EdgeVertexTileRenderer.EdgeSegmentColor(1.0, Color.LIGHT_GRAY));
    }

    private Double findElevationForVertex(Vertex v) {
        return Stream.concat(v.getIncomingStreetEdges().stream().filter(StreetEdge::hasElevationExtension).map(streetEdge -> streetEdge.getElevationProfile().getCoordinate((int)(streetEdge.getElevationProfile().size() - 1)).y), v.getOutgoingStreetEdges().stream().filter(StreetEdge::hasElevationExtension).map(streetEdge -> streetEdge.getElevationProfile().getCoordinate((int)0).y)).findAny().orElse(null);
    }
}

