/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.raster;

import java.awt.Color;
import java.util.Iterator;
import java.util.Optional;
import org.opentripplanner.inspector.raster.EdgeVertexTileRenderer;
import org.opentripplanner.street.model.edge.AreaEdge;
import org.opentripplanner.street.model.edge.AreaEdgeList;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.OsmBoardingLocationVertex;
import org.opentripplanner.street.model.vertex.TransitBoardingAreaVertex;
import org.opentripplanner.street.model.vertex.TransitEntranceVertex;
import org.opentripplanner.street.model.vertex.TransitPathwayNodeVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;

public class AreaEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private static final Color AREA_COLOR = new Color(0.2f, 0.4f, 0.6f);
    private static final Color OSM_BOARDING_LOCATION_VERTEX_COLOR = new Color(23, 160, 234);
    private static final Color TRANSIT_STOP_COLOR_VERTEX = new Color(0.0f, 0.0f, 0.8f);
    private static final Color AREA_COLOR_VERTEX = Color.DARK_GRAY;
    private static final Color VISIBILITY_COLOR_VERTEX = Color.RED;

    private vxType _getAreaVertexType(Vertex v, Iterator<Edge> iterator) {
        vxType val = vxType.OTHER_VERTEX;
        while (iterator.hasNext()) {
            Edge edge = iterator.next();
            if (!(edge instanceof AreaEdge)) continue;
            AreaEdge ae = (AreaEdge)edge;
            AreaEdgeList list = ae.getArea();
            if (list.visibilityVertices.contains(v)) {
                return vxType.VISIBILITY_VERTEX;
            }
            val = vxType.AREA_VERTEX;
        }
        return val;
    }

    private vxType getAreaVertexType(Vertex v) {
        vxType type1 = this._getAreaVertexType(v, v.getOutgoing().iterator());
        if (type1 == vxType.VISIBILITY_VERTEX) {
            return vxType.VISIBILITY_VERTEX;
        }
        vxType type2 = this._getAreaVertexType(v, v.getIncoming().iterator());
        if (type2 == vxType.VISIBILITY_VERTEX) {
            return vxType.VISIBILITY_VERTEX;
        }
        if (type1 == vxType.AREA_VERTEX || type2 == vxType.AREA_VERTEX) {
            return vxType.AREA_VERTEX;
        }
        return vxType.OTHER_VERTEX;
    }

    @Override
    public Optional<EdgeVertexTileRenderer.EdgeVisualAttributes> renderEdge(Edge e) {
        if (e instanceof AreaEdge) {
            AreaEdge ae = (AreaEdge)e;
            return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(AREA_COLOR, "");
        }
        return Optional.empty();
    }

    @Override
    public Optional<EdgeVertexTileRenderer.VertexVisualAttributes> renderVertex(Vertex v) {
        if (v instanceof OsmBoardingLocationVertex) {
            OsmBoardingLocationVertex osmV = (OsmBoardingLocationVertex)v;
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(OSM_BOARDING_LOCATION_VERTEX_COLOR, "OSM refs" + osmV.references);
        }
        if (v instanceof TransitStopVertex || v instanceof TransitEntranceVertex || v instanceof TransitPathwayNodeVertex || v instanceof TransitBoardingAreaVertex) {
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(TRANSIT_STOP_COLOR_VERTEX, v.getDefaultName());
        }
        vxType type = this.getAreaVertexType(v);
        if (type == vxType.VISIBILITY_VERTEX) {
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(VISIBILITY_COLOR_VERTEX, null);
        }
        if (type == vxType.AREA_VERTEX) {
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(AREA_COLOR_VERTEX, null);
        }
        return Optional.empty();
    }

    @Override
    public String getName() {
        return "Areas";
    }

    private static enum vxType {
        VISIBILITY_VERTEX,
        AREA_VERTEX,
        OTHER_VERTEX;

    }
}

