/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.framework.collection.MapUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.BikeAccessMapper;
import org.opentripplanner.gtfs.mapping.DirectionMapper;
import org.opentripplanner.gtfs.mapping.RouteMapper;
import org.opentripplanner.gtfs.mapping.TranslationHelper;
import org.opentripplanner.gtfs.mapping.WheelchairAccessibilityMapper;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripBuilder;

class TripMapper {
    private final RouteMapper routeMapper;
    private final DirectionMapper directionMapper;
    private TranslationHelper translationHelper;
    private final Map<org.onebusaway.gtfs.model.Trip, Trip> mappedTrips = new HashMap<org.onebusaway.gtfs.model.Trip, Trip>();

    TripMapper(RouteMapper routeMapper, DirectionMapper directionMapper, TranslationHelper translationHelper) {
        this.routeMapper = routeMapper;
        this.directionMapper = directionMapper;
        this.translationHelper = translationHelper;
    }

    Collection<Trip> map(Collection<org.onebusaway.gtfs.model.Trip> trips) {
        return MapUtils.mapToList(trips, this::map);
    }

    Trip map(org.onebusaway.gtfs.model.Trip orginal) {
        return orginal == null ? null : this.mappedTrips.computeIfAbsent(orginal, this::doMap);
    }

    Collection<Trip> getMappedTrips() {
        return this.mappedTrips.values();
    }

    private Trip doMap(org.onebusaway.gtfs.model.Trip rhs) {
        TripBuilder lhs = Trip.of(AgencyAndIdMapper.mapAgencyAndId(rhs.getId()));
        lhs.withRoute(this.routeMapper.map(rhs.getRoute()));
        lhs.withServiceId(AgencyAndIdMapper.mapAgencyAndId(rhs.getServiceId()));
        lhs.withShortName(rhs.getTripShortName());
        I18NString tripHeadsign = null;
        if (rhs.getTripHeadsign() != null) {
            tripHeadsign = this.translationHelper.getTranslation(org.onebusaway.gtfs.model.Trip.class, "tripHeadsign", rhs.getId().getId(), rhs.getTripHeadsign());
        }
        lhs.withHeadsign(tripHeadsign);
        lhs.withDirection(this.directionMapper.map(rhs.getDirectionId(), lhs.getId()));
        lhs.withGtfsBlockId(rhs.getBlockId());
        lhs.withShapeId(AgencyAndIdMapper.mapAgencyAndId(rhs.getShapeId()));
        lhs.withWheelchairBoarding(WheelchairAccessibilityMapper.map(rhs.getWheelchairAccessible()));
        lhs.withBikesAllowed(BikeAccessMapper.mapForTrip(rhs));
        lhs.withGtfsFareId(rhs.getFareId());
        return (Trip)lhs.build();
    }
}

