/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.WgsCoordinateMapper;
import org.opentripplanner.gtfs.mapping.WheelchairAccessibilityMapper;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLevel;

class StopMappingWrapper {
    final Stop stop;

    public StopMappingWrapper(Stop stop) {
        this.stop = stop;
    }

    public FeedScopedId getId() {
        return AgencyAndIdMapper.mapAgencyAndId(this.stop.getId());
    }

    public String getName() {
        return this.stop.getName();
    }

    public String getCode() {
        return this.stop.getCode();
    }

    public String getDescription() {
        return this.stop.getDesc();
    }

    public WgsCoordinate getCoordinate() {
        return WgsCoordinateMapper.mapToDomain(this.stop);
    }

    public Accessibility getWheelchairAccessibility() {
        return WheelchairAccessibilityMapper.map(this.stop.getWheelchairBoarding());
    }

    public StopLevel getLevel() {
        if (this.stop.getLevel() == null) {
            return null;
        }
        return new StopLevel(this.stop.getLevel().getName(), this.stop.getLevel().getIndex());
    }

    public FeedScopedId getParentStationId() {
        return this.stop.getParentStation() == null ? null : new FeedScopedId(this.stop.getId().getAgencyId(), this.stop.getParentStation());
    }
}

