/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.framework.collection.MapUtils;
import org.opentripplanner.gtfs.mapping.StopMappingWrapper;
import org.opentripplanner.gtfs.mapping.TransitModeMapper;
import org.opentripplanner.gtfs.mapping.TranslationHelper;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.FareZone;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.RegularStopBuilder;
import org.opentripplanner.transit.model.site.Station;

class StopMapper {
    private final Map<Stop, RegularStop> mappedStops = new HashMap<Stop, RegularStop>();
    private final TranslationHelper translationHelper;
    private final Function<FeedScopedId, Station> stationLookUp;

    StopMapper(TranslationHelper translationHelper, Function<FeedScopedId, Station> stationLookUp) {
        this.translationHelper = translationHelper;
        this.stationLookUp = stationLookUp;
    }

    Collection<RegularStop> map(Collection<Stop> allStops) {
        return MapUtils.mapToList(allStops, this::map);
    }

    RegularStop map(Stop orginal) {
        return orginal == null ? null : this.mappedStops.computeIfAbsent(orginal, this::doMap);
    }

    private RegularStop doMap(Stop gtfsStop) {
        if (gtfsStop.getLocationType() != 0) {
            throw new IllegalArgumentException("Expected type 0, but got " + gtfsStop.getLocationType() + " from stop " + gtfsStop);
        }
        StopMappingWrapper base = new StopMappingWrapper(gtfsStop);
        RegularStopBuilder builder = ((RegularStopBuilder)((RegularStopBuilder)((RegularStopBuilder)((RegularStopBuilder)RegularStop.of(base.getId()).withCode(base.getCode())).withCoordinate(base.getCoordinate())).withWheelchairAccessibility(base.getWheelchairAccessibility())).withLevel(base.getLevel())).withPlatformCode(gtfsStop.getPlatformCode()).withVehicleType(TransitModeMapper.mapMode(gtfsStop.getVehicleType()));
        builder.withName(this.translationHelper.getTranslation(Stop.class, "name", base.getId().getId(), base.getName()));
        builder.withDescription(this.translationHelper.getTranslation(Stop.class, "desc", base.getId().getId(), base.getDescription()));
        builder.withUrl(this.translationHelper.getTranslation(Stop.class, "url", base.getId().getId(), gtfsStop.getUrl()));
        if (gtfsStop.getZoneId() != null) {
            builder.addFareZones((FareZone)FareZone.of(new FeedScopedId(gtfsStop.getId().getAgencyId(), gtfsStop.getZoneId())).build());
        }
        if (gtfsStop.getTimezone() != null) {
            builder.withTimeZone(ZoneId.of(gtfsStop.getTimezone()));
        }
        if (gtfsStop.getParentStation() != null) {
            builder.withParentStation(this.stationLookUp.apply(base.getParentStationId()));
        }
        return (RegularStop)builder.build();
    }
}

