/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import org.onebusaway.gtfs.model.FareTransferRule;
import org.opentripplanner.ext.fares.model.FareProduct;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.FareProductMapper;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class FareTransferRuleMapper {
    public final int MISSING_VALUE = -999;
    private final DataImportIssueStore issueStore;
    private final FareProductMapper fareProductMapper;

    public FareTransferRuleMapper(FareProductMapper fareProductMapper, DataImportIssueStore issueStore) {
        this.fareProductMapper = fareProductMapper;
        this.issueStore = issueStore;
    }

    public Collection<org.opentripplanner.ext.fares.model.FareTransferRule> map(Collection<FareTransferRule> allRules) {
        return allRules.stream().map(this::doMap).filter(Objects::nonNull).toList();
    }

    private org.opentripplanner.ext.fares.model.FareTransferRule doMap(FareTransferRule rhs) {
        FeedScopedId fareProductId = AgencyAndIdMapper.mapAgencyAndId(rhs.getFareProductId());
        return this.fareProductMapper.getByFareProductId(fareProductId).map((? super T p) -> {
            Duration duration = null;
            if (rhs.getDurationLimit() != -999) {
                duration = Duration.ofSeconds(rhs.getDurationLimit());
            }
            return new org.opentripplanner.ext.fares.model.FareTransferRule(AgencyAndIdMapper.mapNullableId(rhs.getFromLegGroupId()), AgencyAndIdMapper.mapNullableId(rhs.getToLegGroupId()), rhs.getTransferCount(), duration, (FareProduct)p);
        }).orElseGet(() -> {
            this.issueStore.add("UnknownFareProductId", "Fare product with id %s referenced by fare transfer rule with id %s not found.".formatted(fareProductId, rhs.getId()));
            return null;
        });
    }
}

