/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.FareRule;
import org.opentripplanner.framework.collection.MapUtils;
import org.opentripplanner.gtfs.mapping.FareAttributeMapper;
import org.opentripplanner.gtfs.mapping.RouteMapper;

class FareRuleMapper {
    private final RouteMapper routeMapper;
    private final FareAttributeMapper fareAttributeMapper;
    private final Map<FareRule, org.opentripplanner.ext.fares.model.FareRule> mappedFareRules = new HashMap<FareRule, org.opentripplanner.ext.fares.model.FareRule>();

    FareRuleMapper(RouteMapper routeMapper, FareAttributeMapper fareAttributeMapper) {
        this.routeMapper = routeMapper;
        this.fareAttributeMapper = fareAttributeMapper;
    }

    Collection<org.opentripplanner.ext.fares.model.FareRule> map(Collection<FareRule> allFareRules) {
        return MapUtils.mapToList(allFareRules, this::map);
    }

    org.opentripplanner.ext.fares.model.FareRule map(FareRule orginal) {
        return orginal == null ? null : this.mappedFareRules.computeIfAbsent(orginal, this::doMap);
    }

    private org.opentripplanner.ext.fares.model.FareRule doMap(FareRule rhs) {
        org.opentripplanner.ext.fares.model.FareRule lhs = new org.opentripplanner.ext.fares.model.FareRule();
        lhs.setFare(this.fareAttributeMapper.map(rhs.getFare()));
        lhs.setRoute(this.routeMapper.map(rhs.getRoute()));
        lhs.setOriginId(rhs.getOriginId());
        lhs.setDestinationId(rhs.getDestinationId());
        lhs.setContainsId(rhs.getContainsId());
        return lhs;
    }
}

