/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.Objects;
import org.onebusaway.gtfs.model.FareLegRule;
import org.opentripplanner.ext.fares.model.Distance;
import org.opentripplanner.ext.fares.model.FareDistance;
import org.opentripplanner.ext.fares.model.FareProduct;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.FareProductMapper;

public final class FareLegRuleMapper {
    private final FareProductMapper fareProductMapper;
    private final DataImportIssueStore issueStore;

    public FareLegRuleMapper(FareProductMapper fareProductMapper, DataImportIssueStore issueStore) {
        this.fareProductMapper = fareProductMapper;
        this.issueStore = issueStore;
    }

    public Collection<org.opentripplanner.ext.fares.model.FareLegRule> map(Collection<FareLegRule> allFareLegRules) {
        return allFareLegRules.stream().map((? super T r) -> {
            FareProduct productForRule = this.fareProductMapper.map(r.getFareProduct());
            FareDistance fareDistance = this.createFareDistance((FareLegRule)r);
            if (productForRule != null) {
                return new org.opentripplanner.ext.fares.model.FareLegRule(r.getLegGroupId(), r.getNetworkId(), r.getFromAreaId(), r.getToAreaId(), fareDistance, productForRule);
            }
            this.issueStore.add("UnknownFareProductId", "Fare leg rule %s refers to unknown fare product %s", r.getId(), r.getFareProduct().getId());
            return null;
        }).filter(Objects::nonNull).toList();
    }

    private FareDistance createFareDistance(FareLegRule fareLegRule) {
        return switch (fareLegRule.getDistanceType()) {
            case 0 -> new FareDistance.Stops(fareLegRule.getMinDistance().intValue(), fareLegRule.getMaxDistance().intValue());
            case 1 -> new FareDistance.LinearDistance(Distance.ofMeters(fareLegRule.getMinDistance()), Distance.ofMeters(fareLegRule.getMaxDistance()));
            default -> null;
        };
    }
}

