/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.time.Duration;
import java.time.LocalTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.BookingRule;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.BookingMethod;
import org.opentripplanner.model.BookingTime;
import org.opentripplanner.transit.model.organization.ContactInfo;

class BookingRuleMapper {
    private final Map<AgencyAndId, BookingInfo> cachedBookingInfos = new HashMap<AgencyAndId, BookingInfo>();

    BookingRuleMapper() {
    }

    BookingInfo map(BookingRule rule) {
        if (rule == null) {
            return null;
        }
        return this.cachedBookingInfos.computeIfAbsent(rule.getId(), k -> new BookingInfo(this.contactInfo(rule), this.bookingMethods(), this.earliestBookingTime(rule), this.latestBookingTime(rule), this.minimumBookingNotice(rule), this.maximumBookingNotice(rule), this.message(rule), this.pickupMessage(rule), this.dropOffMessage(rule)));
    }

    private ContactInfo contactInfo(BookingRule rule) {
        return (ContactInfo)ContactInfo.of().withPhoneNumber(rule.getPhoneNumber()).withInfoUrl(rule.getInfoUrl()).withBookingUrl(rule.getUrl()).build();
    }

    private EnumSet<BookingMethod> bookingMethods() {
        return null;
    }

    private BookingTime earliestBookingTime(BookingRule rule) {
        return new BookingTime(LocalTime.ofSecondOfDay(rule.getPriorNoticeStartTime()), rule.getPriorNoticeStartDay());
    }

    private BookingTime latestBookingTime(BookingRule rule) {
        return new BookingTime(LocalTime.ofSecondOfDay(rule.getPriorNoticeLastTime()), rule.getPriorNoticeLastDay());
    }

    private Duration minimumBookingNotice(BookingRule rule) {
        return Duration.ofSeconds(rule.getPriorNoticeDurationMin());
    }

    private Duration maximumBookingNotice(BookingRule rule) {
        return Duration.ofSeconds(rule.getPriorNoticeDurationMax());
    }

    private String message(BookingRule rule) {
        return rule.getMessage();
    }

    private String pickupMessage(BookingRule rule) {
        return rule.getPickupMessage();
    }

    private String dropOffMessage(BookingRule rule) {
        return rule.getDropOffMessage();
    }
}

