/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.framework.collection.MapUtils;
import org.opentripplanner.gtfs.mapping.StopMappingWrapper;
import org.opentripplanner.gtfs.mapping.TranslationHelper;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.BoardingArea;
import org.opentripplanner.transit.model.site.BoardingAreaBuilder;
import org.opentripplanner.transit.model.site.RegularStop;

class BoardingAreaMapper {
    static final String DEFAULT_NAME = "Boarding area";
    private final Map<Stop, BoardingArea> mappedBoardingAreas = new HashMap<Stop, BoardingArea>();
    private final TranslationHelper translationHelper;
    private final Function<FeedScopedId, RegularStop> stationLookUp;

    BoardingAreaMapper(TranslationHelper translationHelper, Function<FeedScopedId, RegularStop> stationLookUp) {
        this.translationHelper = translationHelper;
        this.stationLookUp = stationLookUp;
    }

    Collection<BoardingArea> map(Collection<Stop> allBoardingAreas) {
        return MapUtils.mapToList(allBoardingAreas, this::map);
    }

    BoardingArea map(Stop orginal) {
        return orginal == null ? null : this.mappedBoardingAreas.computeIfAbsent(orginal, this::doMap);
    }

    private BoardingArea doMap(Stop gtfsStop) {
        if (gtfsStop.getLocationType() != 4) {
            throw new IllegalArgumentException("Expected type 4, but got " + gtfsStop.getLocationType());
        }
        StopMappingWrapper base = new StopMappingWrapper(gtfsStop);
        BoardingAreaBuilder builder = (BoardingAreaBuilder)((BoardingAreaBuilder)((BoardingAreaBuilder)((BoardingAreaBuilder)BoardingArea.of(base.getId()).withCode(base.getCode())).withCoordinate(base.getCoordinate())).withWheelchairAccessibility(base.getWheelchairAccessibility())).withLevel(base.getLevel());
        if (gtfsStop.getParentStation() != null) {
            builder.withParentStop(this.stationLookUp.apply(base.getParentStationId()));
        }
        builder.withName(this.translationHelper.getTranslation(Stop.class, "name", base.getId().getId(), Optional.ofNullable(base.getName()).orElse(DEFAULT_NAME)));
        builder.withDescription(this.translationHelper.getTranslation(Stop.class, "desc", base.getId().getId(), base.getDescription()));
        return (BoardingArea)builder.build();
    }
}

