/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.graphbuilder;

import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.FareContainer;
import org.onebusaway.gtfs.model.FareLegRule;
import org.onebusaway.gtfs.model.FareProduct;
import org.onebusaway.gtfs.model.FareTransferRule;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.RiderCategory;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopArea;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.opentripplanner.ext.fares.impl.DefaultFareServiceFactory;
import org.opentripplanner.ext.fares.model.FareRulesData;
import org.opentripplanner.ext.flex.FlexTripsMapper;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.AddTransitModelEntitiesToGraph;
import org.opentripplanner.graph_builder.module.GtfsFeedId;
import org.opentripplanner.graph_builder.module.ValidateAndInterpolateStopTimesForEachTrip;
import org.opentripplanner.graph_builder.module.geometry.GeometryProcessor;
import org.opentripplanner.graph_builder.module.interlining.InterlineProcessor;
import org.opentripplanner.gtfs.GenerateTripPatternsOperation;
import org.opentripplanner.gtfs.graphbuilder.GtfsBundle;
import org.opentripplanner.gtfs.mapping.GTFSToOtpTransitServiceMapper;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.service.TransitModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsModule
implements GraphBuilderModule {
    public static final Set<Class<?>> FARES_V2_CLASSES = Set.of(FareProduct.class, FareLegRule.class, FareTransferRule.class, RiderCategory.class, FareContainer.class, StopArea.class);
    private static final Logger LOG = LoggerFactory.getLogger(GtfsModule.class);
    private final EntityHandler counter = new EntityCounter();
    private final Set<String> agencyIdsSeen = new HashSet<String>();
    private final ServiceDateInterval transitPeriodLimit;
    private final List<GtfsBundle> gtfsBundles;
    private final FareServiceFactory fareServiceFactory;
    private final TransitModel transitModel;
    private final Graph graph;
    private final DataImportIssueStore issueStore;
    private int nextAgencyId = 1;

    public GtfsModule(List<GtfsBundle> bundles, TransitModel transitModel, Graph graph, DataImportIssueStore issueStore, ServiceDateInterval transitPeriodLimit, FareServiceFactory fareServiceFactory) {
        this.gtfsBundles = bundles;
        this.transitModel = transitModel;
        this.graph = graph;
        this.issueStore = issueStore;
        this.transitPeriodLimit = transitPeriodLimit;
        this.fareServiceFactory = fareServiceFactory;
    }

    public GtfsModule(List<GtfsBundle> bundles, TransitModel transitModel, Graph graph, ServiceDateInterval transitPeriodLimit) {
        this(bundles, transitModel, graph, DataImportIssueStore.NOOP, transitPeriodLimit, new DefaultFareServiceFactory());
    }

    @Override
    public void buildGraph() {
        CalendarServiceData calendarServiceData = new CalendarServiceData();
        boolean hasTransit = false;
        try {
            for (GtfsBundle gtfsBundle : this.gtfsBundles) {
                GtfsMutableRelationalDao gtfsDao = this.loadBundle(gtfsBundle);
                GTFSToOtpTransitServiceMapper mapper = new GTFSToOtpTransitServiceMapper(gtfsBundle.getFeedId().getId(), this.issueStore, gtfsBundle.discardMinTransferTimes(), (GtfsRelationalDao)gtfsDao, gtfsBundle.stationTransferPreference());
                mapper.mapStopTripAndRouteDataIntoBuilder();
                OtpTransitServiceBuilder builder = mapper.getBuilder();
                FareRulesData fareRulesService = mapper.getFareRulesService();
                builder.limitServiceDays(this.transitPeriodLimit);
                calendarServiceData.add(builder.buildCalendarServiceData());
                if (OTPFeature.FlexRouting.isOn()) {
                    builder.getFlexTripsById().addAll(FlexTripsMapper.createFlexTrips(builder, this.issueStore));
                }
                this.validateAndInterpolateStopTimesForEachTrip(builder.getStopTimesSortedByTrip(), this.issueStore, gtfsBundle.removeRepeatedStops());
                mapper.mapAndAddTransfersToBuilder();
                GeometryProcessor geometryProcessor = new GeometryProcessor(builder, gtfsBundle.getMaxStopToShapeSnapDistance(), this.issueStore);
                this.createTripPatterns(this.graph, this.transitModel, builder, calendarServiceData.getServiceIds(), geometryProcessor, this.issueStore);
                OtpTransitService otpTransitService = builder.build();
                hasTransit = hasTransit || otpTransitService.hasActiveTransit();
                this.addTransitModelToGraph(this.graph, this.transitModel, gtfsBundle, otpTransitService);
                if (gtfsBundle.blockBasedInterlining()) {
                    new InterlineProcessor(this.transitModel.getTransferService(), builder.getStaySeatedNotAllowed(), gtfsBundle.maxInterlineDistance(), this.issueStore).run(otpTransitService.getTripPatterns());
                }
                this.fareServiceFactory.processGtfs(fareRulesService, otpTransitService);
                this.graph.setFareService(this.fareServiceFactory.makeFareService());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.gtfsBundles.forEach(GtfsBundle::close);
        }
        this.transitModel.validateTimeZones();
        this.transitModel.updateCalendarServiceData(hasTransit, calendarServiceData, this.issueStore);
    }

    @Override
    public void checkInputs() {
        for (GtfsBundle bundle : this.gtfsBundles) {
            bundle.checkInputs();
        }
    }

    private void validateAndInterpolateStopTimesForEachTrip(TripStopTimes stopTimesByTrip, DataImportIssueStore issueStore, boolean removeRepeatedStops) {
        new ValidateAndInterpolateStopTimesForEachTrip(stopTimesByTrip, true, removeRepeatedStops, issueStore).run();
    }

    private void createTripPatterns(Graph graph, TransitModel transitModel, OtpTransitServiceBuilder builder, Set<FeedScopedId> calServiceIds, GeometryProcessor geometryProcessor, DataImportIssueStore issueStore) {
        GenerateTripPatternsOperation buildTPOp = new GenerateTripPatternsOperation(builder, issueStore, graph.deduplicator, calServiceIds, geometryProcessor);
        buildTPOp.run();
        transitModel.setHasFrequencyService(transitModel.hasFrequencyService() || buildTPOp.hasFrequencyBasedTrips());
        transitModel.setHasScheduledService(transitModel.hasScheduledService() || buildTPOp.hasScheduledTrips());
    }

    private void addTransitModelToGraph(Graph graph, TransitModel transitModel, GtfsBundle gtfsBundle, OtpTransitService otpTransitService) {
        AddTransitModelEntitiesToGraph.addToGraph(otpTransitService, gtfsBundle.subwayAccessTime, graph, transitModel);
    }

    private GtfsMutableRelationalDao loadBundle(GtfsBundle gtfsBundle) throws IOException {
        StoreImpl store = new StoreImpl((GtfsMutableRelationalDao)new GtfsRelationalDaoImpl());
        store.open();
        LOG.info("reading {}", (Object)gtfsBundle.toString());
        GtfsFeedId gtfsFeedId = gtfsBundle.getFeedId();
        GtfsReader reader = new GtfsReader();
        reader.setInputSource(gtfsBundle.getCsvInputSource());
        reader.setEntityStore((GenericMutableDao)store);
        reader.setInternStrings(true);
        reader.setDefaultAgencyId(gtfsFeedId.getId());
        if (LOG.isDebugEnabled()) {
            reader.addEntityHandler(this.counter);
        }
        for (Class entityClass : reader.getEntityClasses()) {
            if (this.skipEntityClass(entityClass)) {
                LOG.info("Skipping entity: {}", (Object)entityClass.getName());
                continue;
            }
            LOG.info("Reading entity: {}", (Object)entityClass.getName());
            reader.readEntities(entityClass);
            store.flush();
            if (entityClass != Agency.class) continue;
            for (Agency agency : reader.getAgencies()) {
                Object agencyId = agency.getId();
                LOG.info("This Agency has the ID {}", agencyId);
                if (agencyId == null || this.agencyIdsSeen.contains(gtfsFeedId.getId() + (String)agencyId)) {
                    String generatedAgencyId = null;
                    while (generatedAgencyId == null || this.agencyIdsSeen.contains(generatedAgencyId)) {
                        generatedAgencyId = "F" + this.nextAgencyId;
                        ++this.nextAgencyId;
                    }
                    LOG.warn("The agency ID '{}' was already seen, or I think it's bad. Replacing with '{}'.", agencyId, (Object)generatedAgencyId);
                    reader.addAgencyIdMapping((String)agencyId, generatedAgencyId);
                    agency.setId(generatedAgencyId);
                    agencyId = generatedAgencyId;
                }
                if (agencyId == null) continue;
                this.agencyIdsSeen.add(gtfsFeedId.getId() + (String)agencyId);
            }
        }
        for (ShapePoint shapePoint : store.getAllEntitiesForType(ShapePoint.class)) {
            shapePoint.getShapeId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (Route route : store.getAllEntitiesForType(Route.class)) {
            route.getId().setAgencyId(reader.getDefaultAgencyId());
            this.generateRouteColor(route);
        }
        for (Stop stop : store.getAllEntitiesForType(Stop.class)) {
            stop.getId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (Trip trip : store.getAllEntitiesForType(Trip.class)) {
            trip.getId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (ServiceCalendar serviceCalendar : store.getAllEntitiesForType(ServiceCalendar.class)) {
            serviceCalendar.getServiceId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (ServiceCalendarDate serviceCalendarDate : store.getAllEntitiesForType(ServiceCalendarDate.class)) {
            serviceCalendarDate.getServiceId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (FareAttribute fareAttribute : store.getAllEntitiesForType(FareAttribute.class)) {
            fareAttribute.getId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (FareProduct fareProduct : store.getAllEntitiesForType(FareProduct.class)) {
            fareProduct.getId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (FareTransferRule transferRule : store.getAllEntitiesForType(FareTransferRule.class)) {
            transferRule.getFareProductId().setAgencyId(reader.getDefaultAgencyId());
            transferRule.getFromLegGroupId().setAgencyId(reader.getDefaultAgencyId());
            transferRule.getToLegGroupId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (Pathway pathway : store.getAllEntitiesForType(Pathway.class)) {
            pathway.getId().setAgencyId(reader.getDefaultAgencyId());
        }
        store.close();
        return store.dao;
    }

    private boolean skipEntityClass(Class<?> entityClass) {
        return OTPFeature.FaresV2.isOff() && FARES_V2_CLASSES.contains(entityClass);
    }

    private void generateRouteColor(Route route) {
        double newBlue;
        double newGreen;
        String routeColor = route.getColor();
        if (routeColor == null) {
            return;
        }
        String textColor = route.getTextColor();
        if (textColor != null) {
            return;
        }
        Color routeColorColor = Color.decode("#" + routeColor);
        float[] colorComponents = routeColorColor.getRGBColorComponents(null);
        double newRed = 0.299 * Math.pow(colorComponents[0], 2.0);
        double luminance = Math.sqrt(newRed + (newGreen = 0.587 * Math.pow(colorComponents[1], 2.0)) + (newBlue = 0.114 * Math.pow(colorComponents[2], 2.0)));
        textColor = luminance > 0.5 ? "000000" : "FFFFFF";
        route.setTextColor(textColor);
    }

    private static class EntityCounter
    implements EntityHandler {
        private final Map<Class<?>, Integer> count = new HashMap();

        private EntityCounter() {
        }

        public void handleEntity(Object bean) {
            int count = this.incrementCount(bean.getClass());
            if (count % 1000000 == 0 && LOG.isDebugEnabled()) {
                String name = bean.getClass().getName();
                int index = name.lastIndexOf(46);
                if (index != -1) {
                    name = name.substring(index + 1);
                }
                LOG.debug("loading {}: {}", (Object)name, (Object)count);
            }
        }

        private int incrementCount(Class<?> entityType) {
            Integer value = this.count.get(entityType);
            if (value == null) {
                value = 0;
            }
            Integer n = value;
            value = value + 1;
            this.count.put(entityType, value);
            return value;
        }
    }

    private static class StoreImpl
    implements GenericMutableDao {
        private final GtfsMutableRelationalDao dao;

        StoreImpl(GtfsMutableRelationalDao dao) {
            this.dao = dao;
        }

        public void open() {
            this.dao.open();
        }

        public void saveEntity(Object entity) {
            this.dao.saveEntity(entity);
        }

        public void updateEntity(Object entity) {
            throw new UnsupportedOperationException();
        }

        public void saveOrUpdateEntity(Object entity) {
            throw new UnsupportedOperationException();
        }

        public <K extends Serializable, T extends IdentityBean<K>> void removeEntity(T entity) {
            throw new UnsupportedOperationException();
        }

        public <T> void clearAllEntitiesForType(Class<T> type) {
            throw new UnsupportedOperationException();
        }

        public void flush() {
            this.dao.flush();
        }

        public void close() {
            this.dao.close();
        }

        public <T> Collection<T> getAllEntitiesForType(Class<T> type) {
            return this.dao.getAllEntitiesForType(type);
        }

        public <T> T getEntityForId(Class<T> type, Serializable id) {
            return (T)this.dao.getEntityForId(type, id);
        }
    }
}

